/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

public enum EventCode {
    OK(0),
    ERROR(1),
    REDIRECT(2),
    AUTHENTICATION_REJECTED(3),
    CLOSED(4),
    NULL_VAL(Integer.MIN_VALUE);

    private final int value;

    private EventCode(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public static EventCode get(int value) {
        switch (value) {
            case 0: {
                return OK;
            }
            case 1: {
                return ERROR;
            }
            case 2: {
                return REDIRECT;
            }
            case 3: {
                return AUTHENTICATION_REJECTED;
            }
            case 4: {
                return CLOSED;
            }
            case -2147483648: {
                return NULL_VAL;
            }
        }
        throw new IllegalArgumentException("Unknown value: " + value);
    }
}

