/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.MetaAttribute;
import io.aeron.cluster.codecs.PendingMessageTrackerDecoder;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public final class PendingMessageTrackerEncoder {
    public static final int BLOCK_LENGTH = 24;
    public static final int TEMPLATE_ID = 107;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 14;
    public static final String SEMANTIC_VERSION = "5.4";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final PendingMessageTrackerEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    public int sbeBlockLength() {
        return 24;
    }

    public int sbeTemplateId() {
        return 107;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 14;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public PendingMessageTrackerEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 24);
        return this;
    }

    public PendingMessageTrackerEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(24).templateId(107).schemaId(111).version(14);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int nextServiceSessionIdId() {
        return 1;
    }

    public static int nextServiceSessionIdSinceVersion() {
        return 0;
    }

    public static int nextServiceSessionIdEncodingOffset() {
        return 0;
    }

    public static int nextServiceSessionIdEncodingLength() {
        return 8;
    }

    public static String nextServiceSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long nextServiceSessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long nextServiceSessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long nextServiceSessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public PendingMessageTrackerEncoder nextServiceSessionId(long value) {
        this.buffer.putLong(this.offset + 0, value, BYTE_ORDER);
        return this;
    }

    public static int logServiceSessionIdId() {
        return 2;
    }

    public static int logServiceSessionIdSinceVersion() {
        return 0;
    }

    public static int logServiceSessionIdEncodingOffset() {
        return 8;
    }

    public static int logServiceSessionIdEncodingLength() {
        return 8;
    }

    public static String logServiceSessionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long logServiceSessionIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long logServiceSessionIdMinValue() {
        return -9223372036854775807L;
    }

    public static long logServiceSessionIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public PendingMessageTrackerEncoder logServiceSessionId(long value) {
        this.buffer.putLong(this.offset + 8, value, BYTE_ORDER);
        return this;
    }

    public static int pendingMessageCapacityId() {
        return 3;
    }

    public static int pendingMessageCapacitySinceVersion() {
        return 0;
    }

    public static int pendingMessageCapacityEncodingOffset() {
        return 16;
    }

    public static int pendingMessageCapacityEncodingLength() {
        return 4;
    }

    public static String pendingMessageCapacityMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "optional";
        }
        return "";
    }

    public static int pendingMessageCapacityNullValue() {
        return 0;
    }

    public static int pendingMessageCapacityMinValue() {
        return -2147483647;
    }

    public static int pendingMessageCapacityMaxValue() {
        return Integer.MAX_VALUE;
    }

    public PendingMessageTrackerEncoder pendingMessageCapacity(int value) {
        this.buffer.putInt(this.offset + 16, value, BYTE_ORDER);
        return this;
    }

    public static int serviceIdId() {
        return 4;
    }

    public static int serviceIdSinceVersion() {
        return 0;
    }

    public static int serviceIdEncodingOffset() {
        return 20;
    }

    public static int serviceIdEncodingLength() {
        return 4;
    }

    public static String serviceIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int serviceIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int serviceIdMinValue() {
        return -2147483647;
    }

    public static int serviceIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public PendingMessageTrackerEncoder serviceId(int value) {
        this.buffer.putInt(this.offset + 20, value, BYTE_ORDER);
        return this;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        PendingMessageTrackerDecoder decoder = new PendingMessageTrackerDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset, 24, 14);
        return decoder.appendTo(builder);
    }
}

