/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.cluster.codecs;


/**
 * Type of event for a response.
 */
@SuppressWarnings("all")
public enum EventCode
{

    /**
     * Operation was successful
     */
    OK(0),


    /**
     * Error occurred during operation.
     */
    ERROR(1),


    /**
     * Redirect to cluster leader.
     */
    REDIRECT(2),


    /**
     * Authentication credentials rejected.
     */
    AUTHENTICATION_REJECTED(3),


    /**
     * Session has been closed.
     */
    CLOSED(4),

    /**
     * To be used to represent not present or null.
     */
    NULL_VAL(-2147483648);

    private final int value;

    EventCode(final int value)
    {
        this.value = value;
    }

    /**
     * The raw encoded value in the Java type representation.
     *
     * @return the raw value encoded.
     */
    public int value()
    {
        return value;
    }

    /**
     * Lookup the enum value representing the value.
     *
     * @param value encoded to be looked up.
     * @return the enum value representing the value.
     */
    public static EventCode get(final int value)
    {
        switch (value)
        {
            case 0: return OK;
            case 1: return ERROR;
            case 2: return REDIRECT;
            case 3: return AUTHENTICATION_REJECTED;
            case 4: return CLOSED;
            case -2147483648: return NULL_VAL;
        }

        throw new IllegalArgumentException("Unknown value: " + value);
    }
}
