/* Generated SBE (Simple Binary Encoding) message codec. */
package io.aeron.cluster.codecs;

import org.agrona.MutableDirectBuffer;


/**
 * A leader has been successfully elected and has begun a new term.
 */
@SuppressWarnings("all")
public final class NewLeadershipTermEncoder
{
    public static final int BLOCK_LENGTH = 88;
    public static final int TEMPLATE_ID = 53;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 14;
    public static final String SEMANTIC_VERSION = "5.4";
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final NewLeadershipTermEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public MutableDirectBuffer buffer()
    {
        return buffer;
    }

    public int offset()
    {
        return offset;
    }

    public NewLeadershipTermEncoder wrap(final MutableDirectBuffer buffer, final int offset)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.offset = offset;
        limit(offset + BLOCK_LENGTH);

        return this;
    }

    public NewLeadershipTermEncoder wrapAndApplyHeader(
        final MutableDirectBuffer buffer, final int offset, final MessageHeaderEncoder headerEncoder)
    {
        headerEncoder
            .wrap(buffer, offset)
            .blockLength(BLOCK_LENGTH)
            .templateId(TEMPLATE_ID)
            .schemaId(SCHEMA_ID)
            .version(SCHEMA_VERSION);

        return wrap(buffer, offset + MessageHeaderEncoder.ENCODED_LENGTH);
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int logLeadershipTermIdId()
    {
        return 1;
    }

    public static int logLeadershipTermIdSinceVersion()
    {
        return 0;
    }

    public static int logLeadershipTermIdEncodingOffset()
    {
        return 0;
    }

    public static int logLeadershipTermIdEncodingLength()
    {
        return 8;
    }

    public static String logLeadershipTermIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long logLeadershipTermIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long logLeadershipTermIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long logLeadershipTermIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public NewLeadershipTermEncoder logLeadershipTermId(final long value)
    {
        buffer.putLong(offset + 0, value, BYTE_ORDER);
        return this;
    }


    public static int nextLeadershipTermIdId()
    {
        return 2;
    }

    public static int nextLeadershipTermIdSinceVersion()
    {
        return 0;
    }

    public static int nextLeadershipTermIdEncodingOffset()
    {
        return 8;
    }

    public static int nextLeadershipTermIdEncodingLength()
    {
        return 8;
    }

    public static String nextLeadershipTermIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long nextLeadershipTermIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long nextLeadershipTermIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long nextLeadershipTermIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public NewLeadershipTermEncoder nextLeadershipTermId(final long value)
    {
        buffer.putLong(offset + 8, value, BYTE_ORDER);
        return this;
    }


    public static int nextTermBaseLogPositionId()
    {
        return 3;
    }

    public static int nextTermBaseLogPositionSinceVersion()
    {
        return 0;
    }

    public static int nextTermBaseLogPositionEncodingOffset()
    {
        return 16;
    }

    public static int nextTermBaseLogPositionEncodingLength()
    {
        return 8;
    }

    public static String nextTermBaseLogPositionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long nextTermBaseLogPositionNullValue()
    {
        return -9223372036854775808L;
    }

    public static long nextTermBaseLogPositionMinValue()
    {
        return -9223372036854775807L;
    }

    public static long nextTermBaseLogPositionMaxValue()
    {
        return 9223372036854775807L;
    }

    public NewLeadershipTermEncoder nextTermBaseLogPosition(final long value)
    {
        buffer.putLong(offset + 16, value, BYTE_ORDER);
        return this;
    }


    public static int nextLogPositionId()
    {
        return 4;
    }

    public static int nextLogPositionSinceVersion()
    {
        return 0;
    }

    public static int nextLogPositionEncodingOffset()
    {
        return 24;
    }

    public static int nextLogPositionEncodingLength()
    {
        return 8;
    }

    public static String nextLogPositionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long nextLogPositionNullValue()
    {
        return -9223372036854775808L;
    }

    public static long nextLogPositionMinValue()
    {
        return -9223372036854775807L;
    }

    public static long nextLogPositionMaxValue()
    {
        return 9223372036854775807L;
    }

    public NewLeadershipTermEncoder nextLogPosition(final long value)
    {
        buffer.putLong(offset + 24, value, BYTE_ORDER);
        return this;
    }


    public static int leadershipTermIdId()
    {
        return 5;
    }

    public static int leadershipTermIdSinceVersion()
    {
        return 0;
    }

    public static int leadershipTermIdEncodingOffset()
    {
        return 32;
    }

    public static int leadershipTermIdEncodingLength()
    {
        return 8;
    }

    public static String leadershipTermIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long leadershipTermIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long leadershipTermIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long leadershipTermIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public NewLeadershipTermEncoder leadershipTermId(final long value)
    {
        buffer.putLong(offset + 32, value, BYTE_ORDER);
        return this;
    }


    public static int termBaseLogPositionId()
    {
        return 6;
    }

    public static int termBaseLogPositionSinceVersion()
    {
        return 0;
    }

    public static int termBaseLogPositionEncodingOffset()
    {
        return 40;
    }

    public static int termBaseLogPositionEncodingLength()
    {
        return 8;
    }

    public static String termBaseLogPositionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long termBaseLogPositionNullValue()
    {
        return -9223372036854775808L;
    }

    public static long termBaseLogPositionMinValue()
    {
        return -9223372036854775807L;
    }

    public static long termBaseLogPositionMaxValue()
    {
        return 9223372036854775807L;
    }

    public NewLeadershipTermEncoder termBaseLogPosition(final long value)
    {
        buffer.putLong(offset + 40, value, BYTE_ORDER);
        return this;
    }


    public static int logPositionId()
    {
        return 7;
    }

    public static int logPositionSinceVersion()
    {
        return 0;
    }

    public static int logPositionEncodingOffset()
    {
        return 48;
    }

    public static int logPositionEncodingLength()
    {
        return 8;
    }

    public static String logPositionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long logPositionNullValue()
    {
        return -9223372036854775808L;
    }

    public static long logPositionMinValue()
    {
        return -9223372036854775807L;
    }

    public static long logPositionMaxValue()
    {
        return 9223372036854775807L;
    }

    public NewLeadershipTermEncoder logPosition(final long value)
    {
        buffer.putLong(offset + 48, value, BYTE_ORDER);
        return this;
    }


    public static int leaderRecordingIdId()
    {
        return 8;
    }

    public static int leaderRecordingIdSinceVersion()
    {
        return 0;
    }

    public static int leaderRecordingIdEncodingOffset()
    {
        return 56;
    }

    public static int leaderRecordingIdEncodingLength()
    {
        return 8;
    }

    public static String leaderRecordingIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long leaderRecordingIdNullValue()
    {
        return -9223372036854775808L;
    }

    public static long leaderRecordingIdMinValue()
    {
        return -9223372036854775807L;
    }

    public static long leaderRecordingIdMaxValue()
    {
        return 9223372036854775807L;
    }

    public NewLeadershipTermEncoder leaderRecordingId(final long value)
    {
        buffer.putLong(offset + 56, value, BYTE_ORDER);
        return this;
    }


    public static int timestampId()
    {
        return 9;
    }

    public static int timestampSinceVersion()
    {
        return 0;
    }

    public static int timestampEncodingOffset()
    {
        return 64;
    }

    public static int timestampEncodingLength()
    {
        return 8;
    }

    public static String timestampMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long timestampNullValue()
    {
        return -9223372036854775808L;
    }

    public static long timestampMinValue()
    {
        return -9223372036854775807L;
    }

    public static long timestampMaxValue()
    {
        return 9223372036854775807L;
    }

    public NewLeadershipTermEncoder timestamp(final long value)
    {
        buffer.putLong(offset + 64, value, BYTE_ORDER);
        return this;
    }


    public static int leaderMemberIdId()
    {
        return 10;
    }

    public static int leaderMemberIdSinceVersion()
    {
        return 0;
    }

    public static int leaderMemberIdEncodingOffset()
    {
        return 72;
    }

    public static int leaderMemberIdEncodingLength()
    {
        return 4;
    }

    public static String leaderMemberIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int leaderMemberIdNullValue()
    {
        return -2147483648;
    }

    public static int leaderMemberIdMinValue()
    {
        return -2147483647;
    }

    public static int leaderMemberIdMaxValue()
    {
        return 2147483647;
    }

    public NewLeadershipTermEncoder leaderMemberId(final int value)
    {
        buffer.putInt(offset + 72, value, BYTE_ORDER);
        return this;
    }


    public static int logSessionIdId()
    {
        return 11;
    }

    public static int logSessionIdSinceVersion()
    {
        return 0;
    }

    public static int logSessionIdEncodingOffset()
    {
        return 76;
    }

    public static int logSessionIdEncodingLength()
    {
        return 4;
    }

    public static String logSessionIdMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static int logSessionIdNullValue()
    {
        return -2147483648;
    }

    public static int logSessionIdMinValue()
    {
        return -2147483647;
    }

    public static int logSessionIdMaxValue()
    {
        return 2147483647;
    }

    public NewLeadershipTermEncoder logSessionId(final int value)
    {
        buffer.putInt(offset + 76, value, BYTE_ORDER);
        return this;
    }


    public static int appVersionId()
    {
        return 12;
    }

    public static int appVersionSinceVersion()
    {
        return 0;
    }

    public static int appVersionEncodingOffset()
    {
        return 80;
    }

    public static int appVersionEncodingLength()
    {
        return 4;
    }

    public static String appVersionMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "optional";
        }

        return "";
    }

    public static int appVersionNullValue()
    {
        return 0;
    }

    public static int appVersionMinValue()
    {
        return 1;
    }

    public static int appVersionMaxValue()
    {
        return 16777215;
    }

    public NewLeadershipTermEncoder appVersion(final int value)
    {
        buffer.putInt(offset + 80, value, BYTE_ORDER);
        return this;
    }


    public static int isStartupId()
    {
        return 13;
    }

    public static int isStartupSinceVersion()
    {
        return 0;
    }

    public static int isStartupEncodingOffset()
    {
        return 84;
    }

    public static int isStartupEncodingLength()
    {
        return 4;
    }

    public static String isStartupMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public NewLeadershipTermEncoder isStartup(final BooleanType value)
    {
        buffer.putInt(offset + 84, value.value(), BYTE_ORDER);
        return this;
    }

    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final NewLeadershipTermDecoder decoder = new NewLeadershipTermDecoder();
        decoder.wrap(buffer, offset, BLOCK_LENGTH, SCHEMA_VERSION);

        return decoder.appendTo(builder);
    }
}
