/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.ExclusivePublication;
import io.aeron.Publication;
import io.aeron.cluster.ClusterSession;
import io.aeron.cluster.ConsensusModule;
import io.aeron.cluster.RecordingLog;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.AppendPositionEncoder;
import io.aeron.cluster.codecs.BackupQueryEncoder;
import io.aeron.cluster.codecs.BackupResponseEncoder;
import io.aeron.cluster.codecs.BooleanType;
import io.aeron.cluster.codecs.CanvassPositionEncoder;
import io.aeron.cluster.codecs.CatchupPositionEncoder;
import io.aeron.cluster.codecs.ChallengeResponseEncoder;
import io.aeron.cluster.codecs.CommitPositionEncoder;
import io.aeron.cluster.codecs.HeartbeatRequestEncoder;
import io.aeron.cluster.codecs.HeartbeatResponseEncoder;
import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.NewLeadershipTermEncoder;
import io.aeron.cluster.codecs.RequestVoteEncoder;
import io.aeron.cluster.codecs.StandbySnapshotEncoder;
import io.aeron.cluster.codecs.StopCatchupEncoder;
import io.aeron.cluster.codecs.TerminationAckEncoder;
import io.aeron.cluster.codecs.TerminationPositionEncoder;
import io.aeron.cluster.codecs.VoteEncoder;
import io.aeron.logbuffer.BufferClaim;
import java.util.List;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;

final class ConsensusPublisher {
    private static final int SEND_ATTEMPTS = 3;
    private final ExpandableArrayBuffer buffer = new ExpandableArrayBuffer();
    private final BufferClaim bufferClaim = new BufferClaim();
    private final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    private final CanvassPositionEncoder canvassPositionEncoder = new CanvassPositionEncoder();
    private final RequestVoteEncoder requestVoteEncoder = new RequestVoteEncoder();
    private final VoteEncoder voteEncoder = new VoteEncoder();
    private final NewLeadershipTermEncoder newLeadershipTermEncoder = new NewLeadershipTermEncoder();
    private final AppendPositionEncoder appendPositionEncoder = new AppendPositionEncoder();
    private final CommitPositionEncoder commitPositionEncoder = new CommitPositionEncoder();
    private final CatchupPositionEncoder catchupPositionEncoder = new CatchupPositionEncoder();
    private final StopCatchupEncoder stopCatchupEncoder = new StopCatchupEncoder();
    private final TerminationPositionEncoder terminationPositionEncoder = new TerminationPositionEncoder();
    private final TerminationAckEncoder terminationAckEncoder = new TerminationAckEncoder();
    private final BackupQueryEncoder backupQueryEncoder = new BackupQueryEncoder();
    private final BackupResponseEncoder backupResponseEncoder = new BackupResponseEncoder();
    private final HeartbeatRequestEncoder heartbeatRequestEncoder = new HeartbeatRequestEncoder();
    private final HeartbeatResponseEncoder heartbeatResponseEncoder = new HeartbeatResponseEncoder();
    private final ChallengeResponseEncoder challengeResponseEncoder = new ChallengeResponseEncoder();
    private final StandbySnapshotEncoder standbySnapshotEncoder = new StandbySnapshotEncoder();

    ConsensusPublisher() {
    }

    void canvassPosition(ExclusivePublication publication, long logLeadershipTermId, long logPosition, long leadershipTermId, int followerMemberId) {
        if (null == publication) {
            return;
        }
        int length = 40;
        int attempts = 3;
        do {
            long position;
            if ((position = publication.tryClaim(40, this.bufferClaim)) > 0L) {
                this.canvassPositionEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).logLeadershipTermId(logLeadershipTermId).logPosition(logPosition).leadershipTermId(leadershipTermId).followerMemberId(followerMemberId).protocolVersion(ConsensusModule.Configuration.PROTOCOL_SEMANTIC_VERSION);
                this.bufferClaim.commit();
                return;
            }
            ConsensusPublisher.checkResult(position, (Publication)publication);
        } while (--attempts > 0);
    }

    boolean requestVote(ExclusivePublication publication, long logLeadershipTermId, long logPosition, long candidateTermId, int candidateMemberId) {
        if (null == publication) {
            return false;
        }
        int length = 40;
        int attempts = 3;
        do {
            long position;
            if ((position = publication.tryClaim(40, this.bufferClaim)) > 0L) {
                this.requestVoteEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).logLeadershipTermId(logLeadershipTermId).logPosition(logPosition).candidateTermId(candidateTermId).candidateMemberId(candidateMemberId).protocolVersion(ConsensusModule.Configuration.PROTOCOL_SEMANTIC_VERSION);
                this.bufferClaim.commit();
                return true;
            }
            ConsensusPublisher.checkResult(position, (Publication)publication);
        } while (--attempts > 0);
        return false;
    }

    void placeVote(ExclusivePublication publication, long candidateTermId, long logLeadershipTermId, long logPosition, int candidateMemberId, int followerMemberId, boolean vote) {
        if (null == publication) {
            return;
        }
        int length = 44;
        int attempts = 3;
        do {
            long position;
            if ((position = publication.tryClaim(44, this.bufferClaim)) > 0L) {
                this.voteEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).candidateTermId(candidateTermId).logLeadershipTermId(logLeadershipTermId).logPosition(logPosition).candidateMemberId(candidateMemberId).followerMemberId(followerMemberId).vote(vote ? BooleanType.TRUE : BooleanType.FALSE);
                this.bufferClaim.commit();
                return;
            }
            ConsensusPublisher.checkResult(position, (Publication)publication);
        } while (--attempts > 0);
    }

    void newLeadershipTerm(ExclusivePublication publication, long logLeadershipTermId, long nextLeadershipTermId, long nextTermBaseLogPosition, long nextLogPosition, long leadershipTermId, long termBaseLogPosition, long logPosition, long leaderRecordingId, long timestamp, int leaderMemberId, int logSessionId, int appVersion, boolean isStartup) {
        if (null == publication) {
            return;
        }
        if (-1 == logSessionId) {
            throw new ClusterException("logSessionId was null, should always have a value");
        }
        int length = 96;
        int attempts = 3;
        do {
            long position;
            if ((position = publication.tryClaim(96, this.bufferClaim)) > 0L) {
                this.newLeadershipTermEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).logLeadershipTermId(logLeadershipTermId).nextLeadershipTermId(nextLeadershipTermId).nextTermBaseLogPosition(nextTermBaseLogPosition).nextLogPosition(nextLogPosition).leadershipTermId(leadershipTermId).termBaseLogPosition(termBaseLogPosition).logPosition(logPosition).leaderRecordingId(leaderRecordingId).timestamp(timestamp).leaderMemberId(leaderMemberId).logSessionId(logSessionId).appVersion(appVersion).isStartup(isStartup ? BooleanType.TRUE : BooleanType.FALSE);
                this.bufferClaim.commit();
                return;
            }
            ConsensusPublisher.checkResult(position, (Publication)publication);
        } while (--attempts > 0);
    }

    boolean appendPosition(ExclusivePublication publication, long leadershipTermId, long logPosition, int followerMemberId, short flags) {
        if (null == publication) {
            return false;
        }
        int length = 29;
        int attempts = 3;
        do {
            long position;
            if ((position = publication.tryClaim(29, this.bufferClaim)) > 0L) {
                this.appendPositionEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).leadershipTermId(leadershipTermId).logPosition(logPosition).followerMemberId(followerMemberId).flags(flags);
                this.bufferClaim.commit();
                return true;
            }
            ConsensusPublisher.checkResult(position, (Publication)publication);
        } while (--attempts > 0);
        return false;
    }

    void commitPosition(ExclusivePublication publication, long leadershipTermId, long logPosition, int leaderMemberId) {
        if (null == publication) {
            return;
        }
        int length = 28;
        int attempts = 3;
        do {
            long position;
            if ((position = publication.tryClaim(28, this.bufferClaim)) > 0L) {
                this.commitPositionEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).leadershipTermId(leadershipTermId).logPosition(logPosition).leaderMemberId(leaderMemberId);
                this.bufferClaim.commit();
                return;
            }
            ConsensusPublisher.checkResult(position, (Publication)publication);
        } while (--attempts > 0);
    }

    boolean catchupPosition(ExclusivePublication publication, long leadershipTermId, long logPosition, int followerMemberId, String catchupEndpoint) {
        if (null == publication) {
            return false;
        }
        int length = 28 + CatchupPositionEncoder.catchupEndpointHeaderLength() + catchupEndpoint.length();
        int attempts = 3;
        do {
            long position;
            if ((position = publication.tryClaim(length, this.bufferClaim)) > 0L) {
                this.catchupPositionEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).leadershipTermId(leadershipTermId).logPosition(logPosition).followerMemberId(followerMemberId).catchupEndpoint(catchupEndpoint);
                this.bufferClaim.commit();
                return true;
            }
            ConsensusPublisher.checkResult(position, (Publication)publication);
        } while (--attempts > 0);
        return false;
    }

    boolean stopCatchup(ExclusivePublication publication, long leadershipTermId, int followerMemberId) {
        if (null == publication) {
            return false;
        }
        int length = 20;
        int attempts = 3;
        do {
            long position;
            if ((position = publication.tryClaim(20, this.bufferClaim)) > 0L) {
                this.stopCatchupEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).leadershipTermId(leadershipTermId).followerMemberId(followerMemberId);
                this.bufferClaim.commit();
                return true;
            }
            ConsensusPublisher.checkResult(position, (Publication)publication);
        } while (--attempts > 0);
        return false;
    }

    boolean terminationPosition(ExclusivePublication publication, long leadershipTermId, long logPosition) {
        if (null == publication) {
            return false;
        }
        int length = 24;
        int attempts = 3;
        do {
            long position;
            if ((position = publication.tryClaim(24, this.bufferClaim)) > 0L) {
                this.terminationPositionEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).leadershipTermId(leadershipTermId).logPosition(logPosition);
                this.bufferClaim.commit();
                return true;
            }
            ConsensusPublisher.checkResult(position, (Publication)publication);
            Thread.yield();
        } while (--attempts > 0);
        return false;
    }

    boolean terminationAck(ExclusivePublication publication, long leadershipTermId, long logPosition, int memberId) {
        if (null == publication) {
            return false;
        }
        int length = 28;
        int attempts = 3;
        do {
            long position;
            if ((position = publication.tryClaim(28, this.bufferClaim)) > 0L) {
                this.terminationAckEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).leadershipTermId(leadershipTermId).logPosition(logPosition).memberId(memberId);
                this.bufferClaim.commit();
                return true;
            }
            ConsensusPublisher.checkResult(position, (Publication)publication);
            Thread.yield();
        } while (--attempts > 0);
        return false;
    }

    boolean backupQuery(ExclusivePublication publication, long correlationId, int responseStreamId, int version, String responseChannel, byte[] encodedCredentials) {
        if (null == publication) {
            return false;
        }
        this.backupQueryEncoder.wrapAndApplyHeader((MutableDirectBuffer)this.buffer, 0, this.messageHeaderEncoder).correlationId(correlationId).responseStreamId(responseStreamId).version(version).responseChannel(responseChannel).putEncodedCredentials(encodedCredentials, 0, encodedCredentials.length);
        int length = 8 + this.backupQueryEncoder.encodedLength();
        return ConsensusPublisher.sendPublication(publication, this.buffer, length);
    }

    boolean backupResponse(ClusterSession session, int commitPositionCounterId, int leaderMemberId, int memberId, RecordingLog.Entry lastEntry, RecordingLog.RecoveryPlan recoveryPlan, String clusterMembers) {
        this.backupResponseEncoder.wrapAndApplyHeader((MutableDirectBuffer)this.buffer, 0, this.messageHeaderEncoder).correlationId(session.correlationId()).logRecordingId(recoveryPlan.log.recordingId).logLeadershipTermId(recoveryPlan.log.leadershipTermId).logTermBaseLogPosition(recoveryPlan.log.termBaseLogPosition).lastLeadershipTermId(lastEntry.leadershipTermId).lastTermBaseLogPosition(lastEntry.termBaseLogPosition).commitPositionCounterId(commitPositionCounterId).leaderMemberId(leaderMemberId).memberId(memberId);
        BackupResponseEncoder.SnapshotsEncoder snapshotsEncoder = this.backupResponseEncoder.snapshotsCount(recoveryPlan.snapshots.size());
        int length = recoveryPlan.snapshots.size();
        for (int i = 0; i < length; ++i) {
            RecordingLog.Snapshot snapshot = recoveryPlan.snapshots.get(i);
            snapshotsEncoder.next().recordingId(snapshot.recordingId).leadershipTermId(snapshot.leadershipTermId).termBaseLogPosition(snapshot.termBaseLogPosition).logPosition(snapshot.logPosition).timestamp(snapshot.timestamp).serviceId(snapshot.serviceId);
        }
        this.backupResponseEncoder.clusterMembers(clusterMembers);
        int length2 = 8 + this.backupResponseEncoder.encodedLength();
        return ConsensusPublisher.sendSession(session, this.buffer, length2);
    }

    boolean heartbeatRequest(ExclusivePublication publication, long correlationId, int responseStreamId, String responseChannel, byte[] encodedCredentials) {
        if (null == publication) {
            return false;
        }
        this.heartbeatRequestEncoder.wrapAndApplyHeader((MutableDirectBuffer)this.buffer, 0, this.messageHeaderEncoder).correlationId(correlationId).responseStreamId(responseStreamId).responseChannel(responseChannel).putEncodedCredentials(encodedCredentials, 0, encodedCredentials.length);
        int length = 8 + this.heartbeatRequestEncoder.encodedLength();
        return ConsensusPublisher.sendPublication(publication, this.buffer, length);
    }

    boolean heartbeatResponse(ClusterSession session) {
        this.heartbeatResponseEncoder.wrapAndApplyHeader((MutableDirectBuffer)this.buffer, 0, this.messageHeaderEncoder).correlationId(session.correlationId());
        int length = 8 + this.heartbeatResponseEncoder.encodedLength();
        return ConsensusPublisher.sendSession(session, this.buffer, length);
    }

    boolean challengeResponse(ExclusivePublication publication, long nextCorrelationId, long clusterSessionId, byte[] encodedChallengeResponse) {
        this.challengeResponseEncoder.wrapAndApplyHeader((MutableDirectBuffer)this.buffer, 0, this.messageHeaderEncoder).correlationId(nextCorrelationId).clusterSessionId(clusterSessionId).putEncodedCredentials(encodedChallengeResponse, 0, encodedChallengeResponse.length);
        int length = 8 + this.challengeResponseEncoder.encodedLength();
        return ConsensusPublisher.sendPublication(publication, this.buffer, length);
    }

    boolean standbySnapshotTaken(ExclusivePublication publication, long correlationId, int version, int responseStreamId, String responseChannel, byte[] encodedCredentials, List<RecordingLog.Entry> snapshots, String archiveEndpoint) {
        int snapshotsLength = snapshots.size();
        this.standbySnapshotEncoder.wrapAndApplyHeader((MutableDirectBuffer)this.buffer, 0, this.messageHeaderEncoder);
        this.standbySnapshotEncoder.correlationId(correlationId).version(version).responseStreamId(responseStreamId);
        StandbySnapshotEncoder.SnapshotsEncoder snapshotsEncoder = this.standbySnapshotEncoder.snapshotsCount(snapshotsLength);
        for (int i = 0; i < snapshotsLength; ++i) {
            RecordingLog.Entry entry = snapshots.get(i);
            snapshotsEncoder.next().recordingId(entry.recordingId).leadershipTermId(entry.leadershipTermId).termBaseLogPosition(entry.termBaseLogPosition).logPosition(entry.logPosition).timestamp(entry.timestamp).serviceId(entry.serviceId).archiveEndpoint(archiveEndpoint);
        }
        this.standbySnapshotEncoder.responseChannel(responseChannel).putEncodedCredentials(encodedCredentials, 0, encodedCredentials.length);
        int encodedLength = 8 + this.standbySnapshotEncoder.encodedLength();
        return ConsensusPublisher.sendPublication(publication, this.buffer, encodedLength);
    }

    private static void checkResult(long position, Publication publication) {
        if (-4L == position) {
            throw new ClusterException("publication is closed");
        }
        if (-5L == position) {
            throw new ClusterException("publication at max position: term-length=" + publication.termBufferLength());
        }
    }

    private static boolean sendPublication(ExclusivePublication publication, ExpandableArrayBuffer buffer, int length) {
        int attempts = 3;
        do {
            long position;
            if ((position = publication.offer((DirectBuffer)buffer, 0, length)) > 0L) {
                return true;
            }
            ConsensusPublisher.checkResult(position, (Publication)publication);
        } while (--attempts > 0);
        return false;
    }

    private static boolean sendSession(ClusterSession session, ExpandableArrayBuffer buffer, int length) {
        int attempts = 3;
        Publication publication = session.responsePublication();
        do {
            long position;
            if ((position = publication.offer((DirectBuffer)buffer, 0, length)) > 0L) {
                return true;
            }
            ConsensusPublisher.checkResult(position, publication);
        } while (--attempts > 0);
        return false;
    }
}

