/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster;

import io.aeron.ChannelUri;
import io.aeron.ExclusivePublication;
import io.aeron.Publication;
import io.aeron.cluster.ClusterSession;
import io.aeron.cluster.client.ClusterException;
import io.aeron.cluster.codecs.ClusterAction;
import io.aeron.cluster.codecs.ClusterActionRequestEncoder;
import io.aeron.cluster.codecs.MessageHeaderEncoder;
import io.aeron.cluster.codecs.NewLeadershipTermEventEncoder;
import io.aeron.cluster.codecs.SessionCloseEventEncoder;
import io.aeron.cluster.codecs.SessionMessageHeaderEncoder;
import io.aeron.cluster.codecs.SessionOpenEventEncoder;
import io.aeron.cluster.codecs.TimerEventEncoder;
import io.aeron.cluster.service.ClusterClock;
import io.aeron.logbuffer.BufferClaim;
import java.util.concurrent.TimeUnit;
import org.agrona.BitUtil;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.ErrorHandler;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

final class LogPublisher {
    private static final int SEND_ATTEMPTS = 3;
    private final MessageHeaderEncoder messageHeaderEncoder = new MessageHeaderEncoder();
    private final SessionMessageHeaderEncoder sessionHeaderEncoder = new SessionMessageHeaderEncoder();
    private final SessionOpenEventEncoder sessionOpenEventEncoder = new SessionOpenEventEncoder();
    private final SessionCloseEventEncoder sessionCloseEventEncoder = new SessionCloseEventEncoder();
    private final TimerEventEncoder timerEventEncoder = new TimerEventEncoder();
    private final ClusterActionRequestEncoder clusterActionRequestEncoder = new ClusterActionRequestEncoder();
    private final NewLeadershipTermEventEncoder newLeadershipTermEventEncoder = new NewLeadershipTermEventEncoder();
    private final UnsafeBuffer sessionHeaderBuffer = new UnsafeBuffer(new byte[32]);
    private final ExpandableArrayBuffer expandableArrayBuffer = new ExpandableArrayBuffer();
    private final BufferClaim bufferClaim = new BufferClaim();
    private final String destinationChannel;
    private ExclusivePublication publication;

    LogPublisher(String destinationChannel) {
        this.destinationChannel = destinationChannel;
        this.sessionHeaderEncoder.wrapAndApplyHeader((MutableDirectBuffer)this.sessionHeaderBuffer, 0, new MessageHeaderEncoder());
    }

    void publication(ExclusivePublication publication) {
        if (null != this.publication) {
            this.publication.close();
        }
        this.publication = publication;
    }

    ExclusivePublication publication() {
        return this.publication;
    }

    void disconnect(ErrorHandler errorHandler) {
        if (null != this.publication) {
            CloseHelper.close((ErrorHandler)errorHandler, (AutoCloseable)this.publication);
            this.publication = null;
        }
    }

    long position() {
        if (null == this.publication) {
            return 0L;
        }
        return this.publication.position();
    }

    int sessionId() {
        return this.publication.sessionId();
    }

    void addDestination(String followerLogEndpoint) {
        if (null != this.publication) {
            this.publication.asyncAddDestination(ChannelUri.createDestinationUri((String)this.destinationChannel, (String)followerLogEndpoint));
        }
    }

    long appendMessage(long leadershipTermId, long clusterSessionId, long timestamp, DirectBuffer buffer, int offset, int length) {
        long position;
        this.sessionHeaderEncoder.leadershipTermId(leadershipTermId).clusterSessionId(clusterSessionId).timestamp(timestamp);
        int attempts = 3;
        while ((position = this.publication.offer((DirectBuffer)this.sessionHeaderBuffer, 0, 32, buffer, offset, length, null)) <= 0L) {
            LogPublisher.checkResult(position, (Publication)this.publication);
            if (--attempts > 0) continue;
        }
        return position;
    }

    long appendSessionOpen(ClusterSession session, long leadershipTermId, long timestamp) {
        long position;
        byte[] encodedPrincipal = session.encodedPrincipal();
        String channel = session.responseChannel();
        this.sessionOpenEventEncoder.wrapAndApplyHeader((MutableDirectBuffer)this.expandableArrayBuffer, 0, this.messageHeaderEncoder).leadershipTermId(leadershipTermId).clusterSessionId(session.id()).correlationId(session.correlationId()).timestamp(timestamp).responseStreamId(session.responseStreamId()).responseChannel(channel).putEncodedPrincipal(encodedPrincipal, 0, encodedPrincipal.length);
        int length = 8 + this.sessionOpenEventEncoder.encodedLength();
        int attempts = 3;
        while ((position = this.publication.offer((DirectBuffer)this.expandableArrayBuffer, 0, length, null)) <= 0L) {
            LogPublisher.checkResult(position, (Publication)this.publication);
            if (--attempts > 0) continue;
        }
        return position;
    }

    boolean appendSessionClose(int memberId, ClusterSession session, long leadershipTermId, long timestamp, TimeUnit timeUnit) {
        int length = 36;
        int attempts = 3;
        do {
            long position;
            if ((position = this.publication.tryClaim(36, this.bufferClaim)) > 0L) {
                this.sessionCloseEventEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).leadershipTermId(leadershipTermId).clusterSessionId(session.id()).timestamp(timestamp).closeReason(session.closeReason());
                this.bufferClaim.commit();
                return true;
            }
            LogPublisher.checkResult(position, (Publication)this.publication);
        } while (--attempts > 0);
        return false;
    }

    long appendTimer(long correlationId, long leadershipTermId, long timestamp) {
        long position;
        int length = 32;
        int attempts = 3;
        do {
            if ((position = this.publication.tryClaim(32, this.bufferClaim)) > 0L) {
                this.timerEventEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).leadershipTermId(leadershipTermId).correlationId(correlationId).timestamp(timestamp);
                this.bufferClaim.commit();
                break;
            }
            LogPublisher.checkResult(position, (Publication)this.publication);
        } while (--attempts > 0);
        return position;
    }

    boolean appendClusterAction(long leadershipTermId, long timestamp, ClusterAction action, int flags) {
        int length = 40;
        int fragmentLength = 72;
        int alignedFragmentLength = BitUtil.align((int)72, (int)32);
        int attempts = 3;
        do {
            long logPosition = this.publication.position() + (long)alignedFragmentLength;
            long position = this.publication.tryClaim(40, this.bufferClaim);
            if (position > 0L) {
                this.clusterActionRequestEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).leadershipTermId(leadershipTermId).logPosition(logPosition).timestamp(timestamp).action(action).flags(flags);
                this.bufferClaim.commit();
                return true;
            }
            LogPublisher.checkResult(position, (Publication)this.publication);
        } while (--attempts > 0);
        return false;
    }

    boolean appendNewLeadershipTermEvent(long leadershipTermId, long timestamp, long termBaseLogPosition, int leaderMemberId, int logSessionId, TimeUnit timeUnit, int appVersion) {
        int length = 56;
        int fragmentLength = 88;
        int alignedFragmentLength = BitUtil.align((int)88, (int)32);
        int attempts = 3;
        do {
            long logPosition = this.publication.position() + (long)alignedFragmentLength;
            long position = this.publication.tryClaim(56, this.bufferClaim);
            if (position > 0L) {
                this.newLeadershipTermEventEncoder.wrapAndApplyHeader(this.bufferClaim.buffer(), this.bufferClaim.offset(), this.messageHeaderEncoder).leadershipTermId(leadershipTermId).logPosition(logPosition).timestamp(timestamp).termBaseLogPosition(termBaseLogPosition).leaderMemberId(leaderMemberId).logSessionId(logSessionId).timeUnit(ClusterClock.map(timeUnit)).appVersion(appVersion);
                this.bufferClaim.commit();
                return true;
            }
            LogPublisher.checkResult(position, (Publication)this.publication);
        } while (--attempts > 0);
        return false;
    }

    private static void checkResult(long position, Publication publication) {
        if (-4L == position) {
            throw new ClusterException("log publication is closed");
        }
        if (-5L == position) {
            throw new ClusterException("log publication at max position: term-length=" + publication.termBufferLength());
        }
    }

    public String toString() {
        return "LogPublisher{destinationChannel='" + this.destinationChannel + "'}";
    }
}

