/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.cluster.codecs;

import io.aeron.cluster.codecs.BooleanType;
import io.aeron.cluster.codecs.MessageHeaderDecoder;
import io.aeron.cluster.codecs.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;

public final class VoteDecoder {
    public static final int BLOCK_LENGTH = 36;
    public static final int TEMPLATE_ID = 52;
    public static final int SCHEMA_ID = 111;
    public static final int SCHEMA_VERSION = 14;
    public static final String SEMANTIC_VERSION = "5.4";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final VoteDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    public int sbeBlockLength() {
        return 36;
    }

    public int sbeTemplateId() {
        return 52;
    }

    public int sbeSchemaId() {
        return 111;
    }

    public int sbeSchemaVersion() {
        return 14;
    }

    public String sbeSemanticType() {
        return "";
    }

    public DirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public VoteDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public VoteDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (52 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public VoteDecoder sbeRewind() {
        return this.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
    }

    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int candidateTermIdId() {
        return 1;
    }

    public static int candidateTermIdSinceVersion() {
        return 0;
    }

    public static int candidateTermIdEncodingOffset() {
        return 0;
    }

    public static int candidateTermIdEncodingLength() {
        return 8;
    }

    public static String candidateTermIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long candidateTermIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long candidateTermIdMinValue() {
        return -9223372036854775807L;
    }

    public static long candidateTermIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long candidateTermId() {
        return this.buffer.getLong(this.offset + 0, BYTE_ORDER);
    }

    public static int logLeadershipTermIdId() {
        return 2;
    }

    public static int logLeadershipTermIdSinceVersion() {
        return 0;
    }

    public static int logLeadershipTermIdEncodingOffset() {
        return 8;
    }

    public static int logLeadershipTermIdEncodingLength() {
        return 8;
    }

    public static String logLeadershipTermIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long logLeadershipTermIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long logLeadershipTermIdMinValue() {
        return -9223372036854775807L;
    }

    public static long logLeadershipTermIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long logLeadershipTermId() {
        return this.buffer.getLong(this.offset + 8, BYTE_ORDER);
    }

    public static int logPositionId() {
        return 3;
    }

    public static int logPositionSinceVersion() {
        return 0;
    }

    public static int logPositionEncodingOffset() {
        return 16;
    }

    public static int logPositionEncodingLength() {
        return 8;
    }

    public static String logPositionMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long logPositionNullValue() {
        return Long.MIN_VALUE;
    }

    public static long logPositionMinValue() {
        return -9223372036854775807L;
    }

    public static long logPositionMaxValue() {
        return Long.MAX_VALUE;
    }

    public long logPosition() {
        return this.buffer.getLong(this.offset + 16, BYTE_ORDER);
    }

    public static int candidateMemberIdId() {
        return 4;
    }

    public static int candidateMemberIdSinceVersion() {
        return 0;
    }

    public static int candidateMemberIdEncodingOffset() {
        return 24;
    }

    public static int candidateMemberIdEncodingLength() {
        return 4;
    }

    public static String candidateMemberIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int candidateMemberIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int candidateMemberIdMinValue() {
        return -2147483647;
    }

    public static int candidateMemberIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int candidateMemberId() {
        return this.buffer.getInt(this.offset + 24, BYTE_ORDER);
    }

    public static int followerMemberIdId() {
        return 5;
    }

    public static int followerMemberIdSinceVersion() {
        return 0;
    }

    public static int followerMemberIdEncodingOffset() {
        return 28;
    }

    public static int followerMemberIdEncodingLength() {
        return 4;
    }

    public static String followerMemberIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int followerMemberIdNullValue() {
        return Integer.MIN_VALUE;
    }

    public static int followerMemberIdMinValue() {
        return -2147483647;
    }

    public static int followerMemberIdMaxValue() {
        return Integer.MAX_VALUE;
    }

    public int followerMemberId() {
        return this.buffer.getInt(this.offset + 28, BYTE_ORDER);
    }

    public static int voteId() {
        return 6;
    }

    public static int voteSinceVersion() {
        return 0;
    }

    public static int voteEncodingOffset() {
        return 32;
    }

    public static int voteEncodingLength() {
        return 4;
    }

    public static String voteMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public int voteRaw() {
        return this.buffer.getInt(this.offset + 32, BYTE_ORDER);
    }

    public BooleanType vote() {
        return BooleanType.get(this.buffer.getInt(this.offset + 32, BYTE_ORDER));
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        VoteDecoder decoder = new VoteDecoder();
        decoder.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[Vote](sbeTemplateId=");
        builder.append(52);
        builder.append("|sbeSchemaId=");
        builder.append(111);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 14) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(14);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 36) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(36);
        builder.append("):");
        builder.append("candidateTermId=");
        builder.append(this.candidateTermId());
        builder.append('|');
        builder.append("logLeadershipTermId=");
        builder.append(this.logLeadershipTermId());
        builder.append('|');
        builder.append("logPosition=");
        builder.append(this.logPosition());
        builder.append('|');
        builder.append("candidateMemberId=");
        builder.append(this.candidateMemberId());
        builder.append('|');
        builder.append("followerMemberId=");
        builder.append(this.followerMemberId());
        builder.append('|');
        builder.append("vote=");
        builder.append((Object)this.vote());
        this.limit(originalLimit);
        return builder;
    }

    public VoteDecoder sbeSkip() {
        this.sbeRewind();
        return this;
    }
}

