/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.DriverConductorProxy;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.UdpChannelTransport;
import io.aeron.driver.media.UdpTransportPoller;
import io.aeron.logbuffer.FrameDescriptor;
import io.aeron.protocol.DataHeaderFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import io.aeron.protocol.SetupFlyweight;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.util.function.Consumer;
import org.agrona.BufferUtil;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.LangUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.UnsafeBuffer;

public final class DataTransportPoller
extends UdpTransportPoller {
    private static final ChannelAndTransport[] EMPTY_TRANSPORTS = new ChannelAndTransport[0];
    private final ByteBuffer byteBuffer = BufferUtil.allocateDirectAligned((int)65504, (int)64);
    private final UnsafeBuffer unsafeBuffer = new UnsafeBuffer(this.byteBuffer);
    private final DataHeaderFlyweight dataMessage = new DataHeaderFlyweight(this.unsafeBuffer);
    private final SetupFlyweight setupMessage = new SetupFlyweight(this.unsafeBuffer);
    private final RttMeasurementFlyweight rttMeasurement = new RttMeasurementFlyweight(this.unsafeBuffer);
    private final Consumer<SelectionKey> selectorPoller = selectionKey -> this.poll((ChannelAndTransport)selectionKey.attachment());
    private ChannelAndTransport[] channelAndTransports = EMPTY_TRANSPORTS;
    private int totalBytesReceived;

    public DataTransportPoller(ErrorHandler errorHandler) {
        super(errorHandler);
    }

    public void close() {
        for (ChannelAndTransport transport : this.channelAndTransports) {
            ReceiveChannelEndpoint receiveChannelEndpoint = transport.channelEndpoint;
            receiveChannelEndpoint.closeMultiRcvDestinationTransports(this);
            CloseHelper.close((ErrorHandler)this.errorHandler, (AutoCloseable)receiveChannelEndpoint);
        }
        super.close();
    }

    @Override
    public int pollTransports() {
        this.totalBytesReceived = 0;
        if (this.channelAndTransports.length <= ITERATION_THRESHOLD) {
            for (ChannelAndTransport channelAndTransport : this.channelAndTransports) {
                this.poll(channelAndTransport);
            }
        } else {
            try {
                this.selector.selectNow(this.selectorPoller);
            }
            catch (IOException ex) {
                this.errorHandler.onError((Throwable)ex);
            }
        }
        return this.totalBytesReceived;
    }

    @Override
    public SelectionKey registerForRead(UdpChannelTransport transport) {
        return this.registerForRead((ReceiveChannelEndpoint)transport, transport, 0);
    }

    public SelectionKey registerForRead(ReceiveChannelEndpoint channelEndpoint, UdpChannelTransport transport, int transportIndex) {
        SelectionKey key = null;
        try {
            ChannelAndTransport channelAndTransport = new ChannelAndTransport(channelEndpoint, transport, transportIndex);
            key = transport.receiveDatagramChannel().register(this.selector, 1, channelAndTransport);
            this.channelAndTransports = (ChannelAndTransport[])ArrayUtil.add((Object[])this.channelAndTransports, (Object)channelAndTransport);
        }
        catch (ClosedChannelException ex) {
            LangUtil.rethrowUnchecked((Throwable)ex);
        }
        return key;
    }

    @Override
    public void cancelRead(UdpChannelTransport transport) {
        this.cancelRead((ReceiveChannelEndpoint)transport, transport);
    }

    public void cancelRead(ReceiveChannelEndpoint channelEndpoint, UdpChannelTransport transport) {
        Object[] transports = this.channelAndTransports;
        int index = -1;
        int length = transports.length;
        for (int i = 0; i < length; ++i) {
            if (channelEndpoint != transports[i].channelEndpoint || transport != transports[i].transport) continue;
            index = i;
            break;
        }
        if (index != -1) {
            this.channelAndTransports = 1 == transports.length ? EMPTY_TRANSPORTS : (ChannelAndTransport[])ArrayUtil.remove((Object[])transports, (int)index);
        }
    }

    public void checkForReResolutions(long nowNs, DriverConductorProxy conductorProxy) {
        for (ChannelAndTransport channelAndTransport : this.channelAndTransports) {
            channelAndTransport.channelEndpoint.checkForReResolution(nowNs, conductorProxy);
        }
    }

    private void poll(ChannelAndTransport channelAndTransport) {
        try {
            this.receive(channelAndTransport);
        }
        catch (Exception ex) {
            this.errorHandler.onError((Throwable)ex);
        }
    }

    private void receive(ChannelAndTransport channelAndTransport) {
        InetSocketAddress srcAddress = channelAndTransport.transport.receive(this.byteBuffer);
        if (null != srcAddress) {
            int length = this.byteBuffer.position();
            this.totalBytesReceived += length;
            ReceiveChannelEndpoint channelEndpoint = channelAndTransport.channelEndpoint;
            if (channelEndpoint.isValidFrame(this.unsafeBuffer, length)) {
                channelEndpoint.receiveHook(this.unsafeBuffer, length, srcAddress);
                int frameType = FrameDescriptor.frameType((UnsafeBuffer)this.unsafeBuffer, (int)0);
                if (1 == frameType || 0 == frameType) {
                    channelEndpoint.onDataPacket(this.dataMessage, this.unsafeBuffer, length, srcAddress, channelAndTransport.transportIndex);
                } else if (5 == frameType) {
                    channelEndpoint.onSetupMessage(this.setupMessage, this.unsafeBuffer, length, srcAddress, channelAndTransport.transportIndex);
                } else if (6 == frameType) {
                    channelEndpoint.onRttMeasurement(this.rttMeasurement, this.unsafeBuffer, length, srcAddress, channelAndTransport.transportIndex);
                }
            }
        }
    }

    public String toString() {
        return "DataTransportPoller{}";
    }

    static class ChannelAndTransport {
        final ReceiveChannelEndpoint channelEndpoint;
        final UdpChannelTransport transport;
        final int transportIndex;

        ChannelAndTransport(ReceiveChannelEndpoint channelEndpoint, UdpChannelTransport transport, int transportIndex) {
            this.channelEndpoint = channelEndpoint;
            this.transport = transport;
            this.transportIndex = transportIndex;
        }
    }
}

