/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.AeronClient;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;
import org.agrona.concurrent.status.AtomicCounter;

final class CounterLink
implements DriverManagedResource {
    private final long registrationId;
    private final AtomicCounter counter;
    private final AeronClient client;
    private boolean reachedEndOfLife = false;

    CounterLink(AtomicCounter counter, long registrationId, AeronClient client) {
        this.registrationId = registrationId;
        this.counter = counter;
        this.client = client;
    }

    @Override
    public void close() {
        this.counter.close();
    }

    @Override
    public void onTimeEvent(long timeNs, long timeMs, DriverConductor conductor) {
        if (this.client.hasTimedOut()) {
            this.reachedEndOfLife = true;
            conductor.unavailableCounter(this.registrationId, this.counterId());
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return this.reachedEndOfLife;
    }

    int counterId() {
        return this.counter.id();
    }

    long registrationId() {
        return this.registrationId;
    }
}

