/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.ErrorCode;
import io.aeron.driver.CongestionControl;
import io.aeron.driver.DriverConductor;
import io.aeron.driver.DriverManagedResource;
import io.aeron.driver.FeedbackDelayGenerator;
import io.aeron.driver.LossDetector;
import io.aeron.driver.LossHandler;
import io.aeron.driver.MediaDriver;
import io.aeron.driver.PublicationImagePadding3;
import io.aeron.driver.Subscribable;
import io.aeron.driver.SubscriberPosition;
import io.aeron.driver.SubscriptionLink;
import io.aeron.driver.UntetheredSubscription;
import io.aeron.driver.buffer.RawLog;
import io.aeron.driver.media.ImageConnection;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.ReceiveDestinationTransport;
import io.aeron.driver.status.SystemCounterDescriptor;
import io.aeron.driver.status.SystemCounters;
import io.aeron.logbuffer.LogBufferDescriptor;
import io.aeron.logbuffer.TermGapFiller;
import io.aeron.logbuffer.TermRebuilder;
import io.aeron.protocol.DataHeaderFlyweight;
import io.aeron.protocol.RttMeasurementFlyweight;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import org.agrona.CloseHelper;
import org.agrona.ErrorHandler;
import org.agrona.collections.ArrayListUtil;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.CachedNanoClock;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.UnsafeBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.Position;
import org.agrona.concurrent.status.ReadablePosition;

public final class PublicationImage
extends PublicationImagePadding3
implements LossHandler,
DriverManagedResource,
Subscribable {
    private static final long SM_EOS_MULTIPLE = 5L;
    private static final VarHandle BEGIN_SM_CHANGE_VH;
    private static final VarHandle END_SM_CHANGE_VH;
    private static final VarHandle BEGIN_LOSS_CHANGE_VH;
    private static final VarHandle END_LOSS_CHANGE_VH;
    private volatile long beginSmChange;
    private volatile long endSmChange;
    private long nextSmPosition;
    private int nextSmReceiverWindowLength;
    private long lastSmChangeNumber;
    private long lastSmPosition;
    private long lastOverrunThreshold;
    private long nextSmDeadlineNs;
    private final long smTimeoutNs;
    private final long maxReceiverWindowLength;
    volatile long beginLossChange;
    volatile long endLossChange;
    int lossTermId;
    int lossTermOffset;
    int lossLength;
    private long lastLossChangeNumber;
    private volatile long timeOfLastStateChangeNs;
    private final long correlationId;
    private final long imageLivenessTimeoutNs;
    private final long untetheredWindowLimitTimeoutNs;
    private final long untetheredLingerTimeoutNs;
    private final long untetheredRestingTimeoutNs;
    private final int sessionId;
    private final int streamId;
    private final int positionBitsToShift;
    private final int termLengthMask;
    private final int initialTermId;
    private final short flags;
    private final boolean isReliable;
    private boolean smEnabled = true;
    private boolean isRebuilding = true;
    private volatile boolean isReceiverReleaseTriggered = false;
    private volatile boolean hasReceiverReleased = false;
    private volatile State state = State.INIT;
    private final CachedNanoClock cachedNanoClock;
    private final ReceiveChannelEndpoint channelEndpoint;
    private final UnsafeBuffer[] termBuffers;
    private final Position hwmPosition;
    private final LossDetector lossDetector;
    private final CongestionControl congestionControl;
    private final ErrorHandler errorHandler;
    private final Position rebuildPosition;
    private final String sourceIdentity;
    private final AtomicCounter heartbeatsReceived;
    private final AtomicCounter statusMessagesSent;
    private final AtomicCounter nakMessagesSent;
    private final AtomicCounter receiverNaksSent;
    private final AtomicCounter flowControlUnderRuns;
    private final AtomicCounter flowControlOverRuns;
    private final AtomicCounter lossGapFills;
    private final AtomicCounter publicationImagesRevoked;
    private final EpochClock epochClock;
    private final NanoClock nanoClock;
    private final RawLog rawLog;

    PublicationImage(long correlationId, MediaDriver.Context ctx, ReceiveChannelEndpoint channelEndpoint, int transportIndex, InetSocketAddress controlAddress, int sessionId, int streamId, int initialTermId, int activeTermId, int termOffset, short flags, RawLog rawLog, long untetheredWindowLimitTimeoutNs, long untetheredLingerTimeoutNs, long untetheredRestingTimeoutNs, FeedbackDelayGenerator lossFeedbackDelayGenerator, ArrayList<SubscriberPosition> subscriberPositions, Position hwmPosition, Position rebuildPosition, AtomicCounter receiverNaksSent, String sourceIdentity, CongestionControl congestionControl) {
        long position;
        long nowNs;
        this.correlationId = correlationId;
        this.imageLivenessTimeoutNs = ctx.imageLivenessTimeoutNs();
        this.receiverNaksSent = receiverNaksSent;
        this.untetheredWindowLimitTimeoutNs = untetheredWindowLimitTimeoutNs;
        this.untetheredLingerTimeoutNs = untetheredLingerTimeoutNs;
        this.untetheredRestingTimeoutNs = untetheredRestingTimeoutNs;
        this.smTimeoutNs = ctx.statusMessageTimeoutNs();
        this.channelEndpoint = channelEndpoint;
        this.sessionId = sessionId;
        this.streamId = streamId;
        this.flags = flags;
        this.rawLog = rawLog;
        this.hwmPosition = hwmPosition;
        this.rebuildPosition = rebuildPosition;
        this.sourceIdentity = sourceIdentity;
        this.initialTermId = initialTermId;
        this.congestionControl = congestionControl;
        this.errorHandler = ctx.errorHandler();
        this.lossReport = ctx.lossReport();
        this.nanoClock = ctx.nanoClock();
        this.epochClock = ctx.epochClock();
        this.cachedNanoClock = ctx.receiverCachedNanoClock();
        this.timeOfLastStateChangeNs = nowNs = this.cachedNanoClock.nanoTime();
        this.timeOfLastPacketNs = nowNs;
        this.subscriberPositions = this.positionArray(subscriberPositions, nowNs);
        this.isReliable = subscriberPositions.get(0).subscription().isReliable();
        SystemCounters systemCounters = ctx.systemCounters();
        this.heartbeatsReceived = systemCounters.get(SystemCounterDescriptor.HEARTBEATS_RECEIVED);
        this.statusMessagesSent = systemCounters.get(SystemCounterDescriptor.STATUS_MESSAGES_SENT);
        this.nakMessagesSent = systemCounters.get(SystemCounterDescriptor.NAK_MESSAGES_SENT);
        this.flowControlUnderRuns = systemCounters.get(SystemCounterDescriptor.FLOW_CONTROL_UNDER_RUNS);
        this.flowControlOverRuns = systemCounters.get(SystemCounterDescriptor.FLOW_CONTROL_OVER_RUNS);
        this.lossGapFills = systemCounters.get(SystemCounterDescriptor.LOSS_GAP_FILLS);
        this.publicationImagesRevoked = systemCounters.get(SystemCounterDescriptor.PUBLICATION_IMAGES_REVOKED);
        this.imageConnections = (ImageConnection[])ArrayUtil.ensureCapacity((Object[])this.imageConnections, (int)(transportIndex + 1));
        this.imageConnections[transportIndex] = new ImageConnection(nowNs, controlAddress);
        this.termBuffers = rawLog.termBuffers();
        this.lossDetector = new LossDetector(lossFeedbackDelayGenerator, this);
        int termLength = rawLog.termLength();
        this.termLengthMask = termLength - 1;
        this.positionBitsToShift = LogBufferDescriptor.positionBitsToShift((int)termLength);
        this.nextSmReceiverWindowLength = congestionControl.initialWindowLength();
        this.maxReceiverWindowLength = congestionControl.maxWindowLength();
        this.nextSmPosition = position = LogBufferDescriptor.computePosition((int)activeTermId, (int)termOffset, (int)this.positionBitsToShift, (int)initialTermId);
        this.lastSmPosition = position;
        this.lastOverrunThreshold = position + (long)(termLength >> 1);
        this.cleanPosition = position;
        hwmPosition.setRelease(position);
        rebuildPosition.setRelease(position);
    }

    @Override
    public boolean free() {
        return this.rawLog.free();
    }

    @Override
    public void close() {
        CloseHelper.close((ErrorHandler)this.errorHandler, (AutoCloseable)this.hwmPosition);
        CloseHelper.close((ErrorHandler)this.errorHandler, (AutoCloseable)this.rebuildPosition);
        CloseHelper.close((ErrorHandler)this.errorHandler, (AutoCloseable)this.receiverNaksSent);
        CloseHelper.closeAll((ErrorHandler)this.errorHandler, (AutoCloseable[])this.subscriberPositions);
        int size = this.untetheredSubscriptions.size();
        for (int i = 0; i < size; ++i) {
            UntetheredSubscription untetheredSubscription = (UntetheredSubscription)this.untetheredSubscriptions.get(i);
            if (UntetheredSubscription.State.RESTING != untetheredSubscription.state) continue;
            CloseHelper.close((ErrorHandler)this.errorHandler, (AutoCloseable)untetheredSubscription.position);
        }
        CloseHelper.close((ErrorHandler)this.errorHandler, (AutoCloseable)this.congestionControl);
    }

    public long correlationId() {
        return this.correlationId;
    }

    public int sessionId() {
        return this.sessionId;
    }

    public int streamId() {
        return this.streamId;
    }

    public String channel() {
        return this.channelEndpoint.originalUriString();
    }

    @Override
    public long subscribableRegistrationId() {
        return this.correlationId;
    }

    @Override
    public void addSubscriber(SubscriptionLink subscriptionLink, ReadablePosition subscriberPosition, long nowNs) {
        this.subscriberPositions = (ReadablePosition[])ArrayUtil.add((Object[])this.subscriberPositions, (Object)subscriberPosition);
        if (!subscriptionLink.isTether()) {
            this.untetheredSubscriptions.add(new UntetheredSubscription(subscriptionLink, subscriberPosition, nowNs));
        }
    }

    @Override
    public void removeSubscriber(SubscriptionLink subscriptionLink, ReadablePosition subscriberPosition) {
        this.subscriberPositions = (ReadablePosition[])ArrayUtil.remove((Object[])this.subscriberPositions, (Object)subscriberPosition);
        subscriberPosition.close();
        if (!subscriptionLink.isTether()) {
            int lastIndex;
            for (int i = lastIndex = this.untetheredSubscriptions.size() - 1; i >= 0; --i) {
                if (((UntetheredSubscription)this.untetheredSubscriptions.get((int)i)).subscriptionLink != subscriptionLink) continue;
                ArrayListUtil.fastUnorderedRemove((ArrayList)this.untetheredSubscriptions, (int)i, (int)lastIndex);
                break;
            }
        }
        if (0 == this.subscriberPositions.length) {
            this.isRebuilding = false;
        }
    }

    @Override
    public void onGapDetected(int termId, int termOffset, int length) {
        int lossReportEndOffset;
        long changeNumber = BEGIN_LOSS_CHANGE_VH.get(this) + 1L;
        BEGIN_LOSS_CHANGE_VH.setRelease(this, changeNumber);
        VarHandle.storeStoreFence();
        this.lossTermId = termId;
        this.lossTermOffset = termOffset;
        this.lossLength = length;
        END_LOSS_CHANGE_VH.setRelease(this, changeNumber);
        if (termId != this.lossReportTermId || termOffset >= (lossReportEndOffset = this.lossReportTermOffset + this.lossReportLength)) {
            this.reportLoss(termId, termOffset, length, length);
        } else if (termOffset + length > lossReportEndOffset) {
            this.reportLoss(termId, termOffset, length, length - (lossReportEndOffset - termOffset));
        }
    }

    String sourceIdentity() {
        return this.sourceIdentity;
    }

    ReceiveChannelEndpoint channelEndpoint() {
        return this.channelEndpoint;
    }

    void removeFromDispatcher() {
        this.channelEndpoint.dispatcher().removePublicationImage(this);
    }

    RawLog rawLog() {
        return this.rawLog;
    }

    void activate() {
        this.timeOfLastStateChangeNs = this.cachedNanoClock.nanoTime();
        this.state(State.ACTIVE);
    }

    void deactivate() {
        if (State.ACTIVE == this.state) {
            long nowNs = this.cachedNanoClock.nanoTime();
            this.isRebuilding = false;
            this.timeOfLastStateChangeNs = nowNs;
            if (!this.isSendingEosSm) {
                boolean bl = this.isSendingEosSm = !this.isEndOfStream || this.rebuildPosition.getVolatile() == this.hwmPosition.get();
            }
            if (this.isSendingEosSm) {
                this.nextSmDeadlineNs = nowNs - 1L;
            }
            this.state(State.DRAINING);
        }
    }

    void receiverRelease() {
        this.hasReceiverReleased = true;
    }

    void addDestination(int transportIndex, ReceiveDestinationTransport transport) {
        this.imageConnections = (ImageConnection[])ArrayUtil.ensureCapacity((Object[])this.imageConnections, (int)(transportIndex + 1));
        if (transport.isMulticast()) {
            this.imageConnections[transportIndex] = new ImageConnection(this.cachedNanoClock.nanoTime(), transport.udpChannel().remoteControl());
        } else if (transport.hasExplicitControl()) {
            this.imageConnections[transportIndex] = new ImageConnection(this.cachedNanoClock.nanoTime(), transport.explicitControlAddress());
        }
    }

    void removeDestination(int transportIndex) {
        this.imageConnections[transportIndex] = null;
        this.updateActiveTransportCount();
    }

    void addDestinationConnectionIfUnknown(int transportIndex, InetSocketAddress remoteAddress) {
        this.trackConnection(transportIndex, remoteAddress, this.cachedNanoClock.nanoTime());
    }

    int trackRebuild(long nowNs) {
        int workCount = 0;
        if (this.isRebuilding) {
            long hwmPosition = this.hwmPosition.getVolatile();
            long minSubscriberPosition = Long.MAX_VALUE;
            long maxSubscriberPosition = 0L;
            for (ReadablePosition subscriberPosition : this.subscriberPositions) {
                long position = subscriberPosition.getVolatile();
                minSubscriberPosition = Math.min(minSubscriberPosition, position);
                maxSubscriberPosition = Math.max(maxSubscriberPosition, position);
            }
            long rebuildPosition = Math.max(this.rebuildPosition.get(), maxSubscriberPosition);
            long scanOutcome = this.lossDetector.scan(this.termBuffers[LogBufferDescriptor.indexByPosition((long)rebuildPosition, (int)this.positionBitsToShift)], rebuildPosition, hwmPosition, nowNs, this.termLengthMask, this.positionBitsToShift, this.initialTermId);
            int rebuildTermOffset = (int)(rebuildPosition & (long)this.termLengthMask);
            long newRebuildPosition = rebuildPosition - (long)rebuildTermOffset + (long)LossDetector.rebuildOffset(scanOutcome);
            this.rebuildPosition.proposeMaxRelease(newRebuildPosition);
            long ccOutcome = this.congestionControl.onTrackRebuild(nowNs, minSubscriberPosition, this.nextSmPosition, hwmPosition, rebuildPosition, newRebuildPosition, LossDetector.lossFound(scanOutcome));
            int windowLength = CongestionControl.receiverWindowLength(ccOutcome);
            int threshold = CongestionControl.threshold(windowLength);
            if (CongestionControl.shouldForceStatusMessage(ccOutcome) || minSubscriberPosition > this.nextSmPosition + (long)threshold || windowLength != this.nextSmReceiverWindowLength) {
                this.cleanBufferTo(minSubscriberPosition - (long)(this.termLengthMask + 1));
                this.scheduleStatusMessage(minSubscriberPosition, windowLength);
                ++workCount;
            }
        }
        return workCount;
    }

    int insertPacket(int termId, int termOffset, UnsafeBuffer buffer, int length, int transportIndex, InetSocketAddress srcAddress) {
        long proposedPosition;
        if (null != this.rejectionReason) {
            return 0;
        }
        boolean isHeartbeat = DataHeaderFlyweight.isHeartbeat((UnsafeBuffer)buffer, (int)length);
        long packetPosition = LogBufferDescriptor.computePosition((int)termId, (int)termOffset, (int)this.positionBitsToShift, (int)this.initialTermId);
        long l = proposedPosition = isHeartbeat ? packetPosition : packetPosition + (long)length;
        if (!this.isFlowControlOverRun(proposedPosition)) {
            if (isHeartbeat) {
                long publicationWindowBottom;
                long potentialWindowBottom = this.lastSmPosition - (long)(this.termLengthMask + 1);
                long l2 = publicationWindowBottom = potentialWindowBottom < 0L ? 0L : potentialWindowBottom;
                if (packetPosition >= publicationWindowBottom) {
                    long nowNs;
                    this.timeOfLastPacketNs = nowNs = this.cachedNanoClock.nanoTime();
                    ImageConnection imageConnection = this.trackConnection(transportIndex, srcAddress, nowNs);
                    if (DataHeaderFlyweight.isEndOfStream((UnsafeBuffer)buffer)) {
                        imageConnection.eosPosition = packetPosition;
                        imageConnection.isEos = true;
                        if (!this.isEndOfStream && this.isAllConnectedEos()) {
                            long eosPosition = this.findEosPosition();
                            if (DataHeaderFlyweight.isRevoked((UnsafeBuffer)buffer)) {
                                LogBufferDescriptor.isPublicationRevoked((UnsafeBuffer)this.rawLog.metaData(), (boolean)true);
                                PublicationImage.logRevoke(eosPosition, this.sessionId(), this.streamId(), this.channel());
                                this.publicationImagesRevoked.increment();
                            }
                            LogBufferDescriptor.endOfStreamPosition((UnsafeBuffer)this.rawLog.metaData(), (long)eosPosition);
                            this.isEndOfStream = true;
                        }
                    }
                    this.hwmPosition.proposeMaxRelease(proposedPosition);
                    this.heartbeatsReceived.incrementRelease();
                } else {
                    this.flowControlUnderRuns.incrementRelease();
                }
            } else if (!this.isFlowControlUnderRun(packetPosition)) {
                long nowNs;
                this.timeOfLastPacketNs = nowNs = this.cachedNanoClock.nanoTime();
                this.trackConnection(transportIndex, srcAddress, nowNs);
                UnsafeBuffer termBuffer = this.termBuffers[LogBufferDescriptor.indexByPosition((long)packetPosition, (int)this.positionBitsToShift)];
                TermRebuilder.insert((UnsafeBuffer)termBuffer, (int)termOffset, (UnsafeBuffer)buffer, (int)length);
                this.hwmPosition.proposeMaxRelease(proposedPosition);
            } else if (packetPosition >= this.lastSmPosition - this.maxReceiverWindowLength) {
                this.trackConnection(transportIndex, srcAddress, this.cachedNanoClock.nanoTime());
            }
        }
        return length;
    }

    private static void logRevoke(long revokedPos, int sessionId, int streamId, String channel) {
    }

    boolean isConnected(long nowNs) {
        return this.timeOfLastPacketNs + this.imageLivenessTimeoutNs - nowNs >= 0L && !this.channelEndpoint.isClosed() && (!this.isEndOfStream || !this.isReceiverReleaseTriggered);
    }

    boolean isEndOfStream() {
        return this.isEndOfStream;
    }

    void checkEosForDrainTransition(long nowNs) {
        if (!this.isSendingEosSm && this.isEndOfStream && this.rebuildPosition.getVolatile() == this.hwmPosition.get() && State.ACTIVE == this.state) {
            this.isRebuilding = false;
            this.timeOfLastStateChangeNs = nowNs;
            this.isSendingEosSm = true;
            this.nextSmDeadlineNs = nowNs - 1L;
            this.state(State.DRAINING);
        }
    }

    int sendPendingStatusMessage(long nowNs) {
        Integer responseSessionId;
        boolean hasSmTimedOut;
        int workCount = 0;
        long changeNumber = END_SM_CHANGE_VH.getAcquire(this);
        boolean bl = hasSmTimedOut = this.smEnabled && this.nextSmDeadlineNs - nowNs < 0L;
        if (null != this.rejectionReason) {
            if (hasSmTimedOut) {
                this.channelEndpoint.sendErrorFrame(this.imageConnections, this.sessionId, this.streamId, ErrorCode.IMAGE_REJECTED.value(), this.rejectionReason);
                this.nextSmDeadlineNs = nowNs + this.smTimeoutNs;
                ++workCount;
            }
            return workCount;
        }
        if (hasSmTimedOut && null != (responseSessionId = this.responseSessionId)) {
            this.channelEndpoint.sendResponseSetup(this.imageConnections, this.sessionId, this.streamId, responseSessionId);
        }
        if (changeNumber != this.lastSmChangeNumber || hasSmTimedOut) {
            long smPosition = this.nextSmPosition;
            int receiverWindowLength = this.nextSmReceiverWindowLength;
            VarHandle.loadLoadFence();
            if (changeNumber == BEGIN_SM_CHANGE_VH.getAcquire(this)) {
                int termId = LogBufferDescriptor.computeTermIdFromPosition((long)smPosition, (int)this.positionBitsToShift, (int)this.initialTermId);
                int termOffset = (int)smPosition & this.termLengthMask;
                int termLength = this.termLengthMask + 1;
                short flags = this.isSendingEosSm ? (short)64 : 0;
                this.channelEndpoint.sendStatusMessage(this.imageConnections, this.sessionId, this.streamId, termId, termOffset, receiverWindowLength, flags);
                this.statusMessagesSent.incrementRelease();
                this.lastSmPosition = smPosition;
                this.lastOverrunThreshold = smPosition + (long)(termLength >> 1);
                this.lastSmChangeNumber = changeNumber;
                this.nextSmDeadlineNs = nowNs + this.smTimeoutNs;
                this.updateActiveTransportCount();
            }
            workCount = 1;
        }
        return workCount;
    }

    int processPendingLoss() {
        if (LogBufferDescriptor.isPublicationRevoked((UnsafeBuffer)this.rawLog.metaData())) {
            return 0;
        }
        int workCount = 0;
        long changeNumber = END_LOSS_CHANGE_VH.getAcquire(this);
        if (changeNumber != this.lastLossChangeNumber) {
            int termId = this.lossTermId;
            int termOffset = this.lossTermOffset;
            int length = this.lossLength;
            VarHandle.loadLoadFence();
            if (changeNumber == BEGIN_LOSS_CHANGE_VH.getAcquire(this)) {
                if (this.isReliable) {
                    this.channelEndpoint.sendNakMessage(this.imageConnections, this.sessionId, this.streamId, termId, termOffset, length);
                    this.nakMessagesSent.incrementRelease();
                    this.receiverNaksSent.incrementRelease();
                } else {
                    UnsafeBuffer termBuffer = this.termBuffers[LogBufferDescriptor.indexByTerm((int)this.initialTermId, (int)termId)];
                    if (TermGapFiller.tryFillGap((UnsafeBuffer)this.rawLog.metaData(), (UnsafeBuffer)termBuffer, (int)termId, (int)termOffset, (int)length)) {
                        this.lossGapFills.incrementRelease();
                    }
                }
                this.lastLossChangeNumber = changeNumber;
            }
            workCount = 1;
        }
        return workCount;
    }

    int initiateAnyRttMeasurements(long nowNs) {
        int workCount = 0;
        if (this.congestionControl.shouldMeasureRtt(nowNs)) {
            long preciseTimeNs = this.nanoClock.nanoTime();
            this.channelEndpoint.sendRttMeasurement(this.imageConnections, this.sessionId, this.streamId, preciseTimeNs, 0L, true);
            this.congestionControl.onRttMeasurementSent(preciseTimeNs);
            workCount = 1;
        }
        return workCount;
    }

    void onRttMeasurement(RttMeasurementFlyweight header, int transportIndex, InetSocketAddress srcAddress) {
        long nowNs = this.nanoClock.nanoTime();
        long rttInNs = nowNs - header.echoTimestampNs() - header.receptionDelta();
        this.congestionControl.onRttMeasurement(nowNs, rttInNs, srcAddress);
    }

    boolean isAcceptingSubscriptions() {
        if (this.subscriberPositions.length > 0) {
            State state = this.state;
            return State.INIT == state || State.ACTIVE == state || State.DRAINING == state && !this.isDrained();
        }
        return false;
    }

    long joinPosition() {
        long position = this.rebuildPosition.get();
        for (ReadablePosition subscriberPosition : this.subscriberPositions) {
            position = Math.min(subscriberPosition.getVolatile(), position);
        }
        return position;
    }

    boolean hasSendResponseSetup() {
        return 0 != (0x80 & this.flags);
    }

    void responseSessionId(Integer responseSessionId) {
        this.responseSessionId = responseSessionId;
    }

    @Override
    public void onTimeEvent(long timeNs, long timesMs, DriverConductor conductor) {
        switch (this.state) {
            case ACTIVE: {
                if (LogBufferDescriptor.isPublicationRevoked((UnsafeBuffer)this.rawLog.metaData())) {
                    this.state(State.DRAINING);
                    break;
                }
                this.checkUntetheredSubscriptions(timeNs, conductor);
                break;
            }
            case DRAINING: {
                if ((!this.isDrained() || this.timeOfLastStateChangeNs + 5L * this.smTimeoutNs - timeNs >= 0L) && !LogBufferDescriptor.isPublicationRevoked((UnsafeBuffer)this.rawLog.metaData())) break;
                if (LogBufferDescriptor.isPublicationRevoked((UnsafeBuffer)this.rawLog.metaData())) {
                    this.isRebuilding = false;
                    this.isSendingEosSm = true;
                    this.nextSmDeadlineNs = timeNs - 1L;
                }
                conductor.transitionToLinger(this);
                this.channelEndpoint.decRefImages();
                conductor.tryCloseReceiveChannelEndpoint(this.channelEndpoint);
                this.timeOfLastStateChangeNs = timeNs;
                this.isReceiverReleaseTriggered = true;
                this.state(State.LINGER);
                break;
            }
            case LINGER: {
                if (!this.hasNoSubscribers() && this.timeOfLastStateChangeNs + this.imageLivenessTimeoutNs - timeNs >= 0L) break;
                conductor.cleanupImage(this);
                this.timeOfLastStateChangeNs = timeNs;
                this.state(State.DONE);
                break;
            }
        }
    }

    @Override
    public boolean hasReachedEndOfLife() {
        return this.hasReceiverReleased && State.DONE == this.state;
    }

    void reject(String reason) {
        this.rejectionReason = reason;
    }

    void stopStatusMessagesIfNotActive() {
        if (State.ACTIVE != this.state) {
            this.smEnabled = false;
        }
    }

    private void reportLoss(int termId, int termOffset, int length, int bytesLost) {
        if (null != this.reportEntry) {
            this.reportEntry.recordObservation(bytesLost, this.epochClock.time());
        } else if (null != this.lossReport) {
            this.reportEntry = this.lossReport.createEntry(bytesLost, this.epochClock.time(), this.sessionId, this.streamId, this.channel(), this.sourceIdentity);
            if (null == this.reportEntry) {
                this.lossReport = null;
            }
        }
        this.lossReportTermId = termId;
        this.lossReportTermOffset = termOffset;
        this.lossReportLength = length;
    }

    private void state(State state) {
        this.state = state;
    }

    private boolean isDrained() {
        long rebuildPosition = this.rebuildPosition.get();
        for (ReadablePosition subscriberPosition : this.subscriberPositions) {
            if (subscriberPosition.getVolatile() >= rebuildPosition) continue;
            return false;
        }
        return true;
    }

    private boolean hasNoSubscribers() {
        return this.subscriberPositions.length == 0;
    }

    private boolean isFlowControlUnderRun(long packetPosition) {
        boolean isFlowControlUnderRun;
        boolean bl = isFlowControlUnderRun = packetPosition < this.lastSmPosition;
        if (isFlowControlUnderRun) {
            this.flowControlUnderRuns.incrementRelease();
        }
        return isFlowControlUnderRun;
    }

    private boolean isFlowControlOverRun(long proposedPosition) {
        boolean isFlowControlOverRun;
        boolean bl = isFlowControlOverRun = proposedPosition > this.lastOverrunThreshold;
        if (isFlowControlOverRun) {
            this.flowControlOverRuns.incrementRelease();
        }
        return isFlowControlOverRun;
    }

    private void cleanBufferTo(long position) {
        long cleanPosition = this.cleanPosition;
        if (position > cleanPosition) {
            int bytesForCleaning = (int)(position - cleanPosition);
            UnsafeBuffer dirtyTermBuffer = this.termBuffers[LogBufferDescriptor.indexByPosition((long)cleanPosition, (int)this.positionBitsToShift)];
            int termOffset = (int)cleanPosition & this.termLengthMask;
            int length = Math.min(bytesForCleaning, dirtyTermBuffer.capacity() - termOffset);
            dirtyTermBuffer.setMemory(termOffset, length - 8, (byte)0);
            dirtyTermBuffer.putLongRelease(termOffset + (length - 8), 0L);
            this.cleanPosition = cleanPosition + (long)length;
        }
    }

    private ImageConnection trackConnection(int transportIndex, InetSocketAddress srcAddress, long nowNs) {
        ImageConnection imageConnection;
        ImageConnection[] imageConnections = this.imageConnections;
        if (transportIndex >= imageConnections.length) {
            this.imageConnections = imageConnections = Arrays.copyOf(imageConnections, transportIndex + 1);
        }
        if (null == (imageConnection = imageConnections[transportIndex])) {
            imageConnections[transportIndex] = imageConnection = new ImageConnection(nowNs, srcAddress);
        }
        imageConnection.timeOfLastActivityNs = nowNs;
        imageConnection.timeOfLastFrameNs = nowNs;
        return imageConnection;
    }

    private boolean isAllConnectedEos() {
        int length = this.imageConnections.length;
        for (int i = 0; i < length; ++i) {
            ImageConnection imageConnection = this.imageConnections[i];
            if (null != imageConnection && !imageConnection.isEos) {
                return false;
            }
            if (null != imageConnection || !this.channelEndpoint.hasDestination(i)) continue;
            return false;
        }
        return true;
    }

    private long findEosPosition() {
        long eosPosition = 0L;
        for (ImageConnection imageConnection : this.imageConnections) {
            if (null == imageConnection || imageConnection.eosPosition <= eosPosition) continue;
            eosPosition = imageConnection.eosPosition;
        }
        return eosPosition;
    }

    private void scheduleStatusMessage(long smPosition, int receiverWindowLength) {
        long changeNumber = BEGIN_SM_CHANGE_VH.get(this) + 1L;
        BEGIN_SM_CHANGE_VH.setRelease(this, changeNumber);
        VarHandle.storeStoreFence();
        this.nextSmPosition = smPosition;
        this.nextSmReceiverWindowLength = receiverWindowLength;
        END_SM_CHANGE_VH.setRelease(this, changeNumber);
    }

    private void checkUntetheredSubscriptions(long nowNs, DriverConductor conductor) {
        ArrayList untetheredSubscriptions = this.untetheredSubscriptions;
        int untetheredSubscriptionsSize = untetheredSubscriptions.size();
        if (untetheredSubscriptionsSize > 0) {
            int lastIndex;
            long untetheredWindowLimit = this.untetheredWindowLimit();
            for (int i = lastIndex = untetheredSubscriptionsSize - 1; i >= 0; --i) {
                UntetheredSubscription untethered = (UntetheredSubscription)untetheredSubscriptions.get(i);
                if (UntetheredSubscription.State.ACTIVE == untethered.state) {
                    if (untethered.position.getVolatile() > untetheredWindowLimit) {
                        untethered.timeOfLastUpdateNs = nowNs;
                        continue;
                    }
                    if (untethered.timeOfLastUpdateNs + this.untetheredWindowLimitTimeoutNs - nowNs > 0L) continue;
                    conductor.notifyUnavailableImageLink(this.correlationId, untethered.subscriptionLink);
                    untethered.state(UntetheredSubscription.State.LINGER, nowNs, this.streamId, this.sessionId);
                    continue;
                }
                if (UntetheredSubscription.State.LINGER == untethered.state) {
                    if (untethered.timeOfLastUpdateNs + this.untetheredLingerTimeoutNs - nowNs > 0L) continue;
                    this.subscriberPositions = (ReadablePosition[])ArrayUtil.remove((Object[])this.subscriberPositions, (Object)untethered.position);
                    if (untethered.subscriptionLink.isRejoin()) {
                        untethered.state(UntetheredSubscription.State.RESTING, nowNs, this.streamId, this.sessionId);
                        continue;
                    }
                    ArrayListUtil.fastUnorderedRemove((ArrayList)untetheredSubscriptions, (int)i, (int)lastIndex--);
                    untethered.position.close();
                    continue;
                }
                if (UntetheredSubscription.State.RESTING != untethered.state || untethered.timeOfLastUpdateNs + this.untetheredRestingTimeoutNs - nowNs > 0L) continue;
                long joinPosition = this.joinPosition();
                this.subscriberPositions = (ReadablePosition[])ArrayUtil.add((Object[])this.subscriberPositions, (Object)untethered.position);
                conductor.notifyAvailableImageLink(this.correlationId, this.sessionId, untethered.subscriptionLink, untethered.position.id(), joinPosition, this.rawLog.fileName(), this.sourceIdentity);
                untethered.state(UntetheredSubscription.State.ACTIVE, nowNs, this.streamId, this.sessionId);
            }
        }
    }

    private long untetheredWindowLimit() {
        long maxConsumerPosition = 0L;
        for (ReadablePosition subscriberPosition : this.subscriberPositions) {
            long position = subscriberPosition.getVolatile();
            if (position <= maxConsumerPosition) continue;
            maxConsumerPosition = position;
        }
        int windowLength = this.nextSmReceiverWindowLength;
        return maxConsumerPosition - (long)windowLength + (long)(windowLength >> 2);
    }

    private void updateActiveTransportCount() {
        long nowNs = this.cachedNanoClock.nanoTime();
        int activeTransportCount = 0;
        for (ImageConnection imageConnection : this.imageConnections) {
            if (null == imageConnection || imageConnection.timeOfLastFrameNs + this.imageLivenessTimeoutNs - nowNs <= 0L) continue;
            ++activeTransportCount;
        }
        UnsafeBuffer metaDataBuffer = this.rawLog.metaData();
        if (metaDataBuffer.getInt(LogBufferDescriptor.LOG_ACTIVE_TRANSPORT_COUNT) != activeTransportCount) {
            LogBufferDescriptor.activeTransportCount((UnsafeBuffer)metaDataBuffer, (int)activeTransportCount);
        }
    }

    private ReadablePosition[] positionArray(ArrayList<SubscriberPosition> subscriberPositions, long nowNs) {
        int size = subscriberPositions.size();
        ReadablePosition[] positions = new ReadablePosition[subscriberPositions.size()];
        for (int i = 0; i < size; ++i) {
            SubscriberPosition subscriberPosition = subscriberPositions.get(i);
            positions[i] = subscriberPosition.position();
            if (subscriberPosition.subscription().isTether()) continue;
            this.untetheredSubscriptions.add(new UntetheredSubscription(subscriberPosition.subscription(), (ReadablePosition)subscriberPosition.position(), nowNs));
        }
        return positions;
    }

    public String toString() {
        return "PublicationImage{state=" + String.valueOf((Object)this.state) + ", sourceIdentity='" + this.sourceIdentity + "', streamId=" + this.streamId + ", sessionId=" + this.sessionId + "}";
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            BEGIN_SM_CHANGE_VH = lookup.findVarHandle(PublicationImage.class, "beginSmChange", Long.TYPE);
            END_SM_CHANGE_VH = lookup.findVarHandle(PublicationImage.class, "endSmChange", Long.TYPE);
            BEGIN_LOSS_CHANGE_VH = lookup.findVarHandle(PublicationImage.class, "beginLossChange", Long.TYPE);
            END_LOSS_CHANGE_VH = lookup.findVarHandle(PublicationImage.class, "endLossChange", Long.TYPE);
        }
        catch (ReflectiveOperationException ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }

    static enum State {
        INIT,
        ACTIVE,
        DRAINING,
        LINGER,
        DONE;

    }
}

