/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.FeedbackDelayGenerator;
import io.aeron.driver.FlowControl;
import io.aeron.driver.RetransmitSender;
import org.agrona.concurrent.NanoClock;
import org.agrona.concurrent.status.AtomicCounter;

public final class RetransmitHandler {
    private final RetransmitAction[] retransmitActionPool;
    private final NanoClock nanoClock;
    private final FeedbackDelayGenerator delayGenerator;
    private final FeedbackDelayGenerator lingerTimeoutGenerator;
    private final AtomicCounter invalidPackets;
    private final boolean hasGroupSemantics;
    private final AtomicCounter retransmitOverflowCounter;
    private int activeRetransmitCount = 0;

    public RetransmitHandler(NanoClock nanoClock, AtomicCounter invalidPackets, FeedbackDelayGenerator delayGenerator, FeedbackDelayGenerator lingerTimeoutGenerator, boolean hasGroupSemantics, int maxRetransmits, AtomicCounter retransmitOverflowCounter) {
        this.nanoClock = nanoClock;
        this.invalidPackets = invalidPackets;
        this.delayGenerator = delayGenerator;
        this.lingerTimeoutGenerator = lingerTimeoutGenerator;
        this.hasGroupSemantics = hasGroupSemantics;
        this.retransmitOverflowCounter = retransmitOverflowCounter;
        int actualMaxRetransmits = this.hasGroupSemantics ? maxRetransmits : 1;
        this.retransmitActionPool = new RetransmitAction[actualMaxRetransmits];
        for (int i = 0; i < actualMaxRetransmits; ++i) {
            this.retransmitActionPool[i] = new RetransmitAction();
        }
    }

    public void onNak(int termId, int termOffset, int length, int termLength, int mtuLength, FlowControl flowControl, RetransmitSender retransmitSender) {
        int retransmitLength;
        RetransmitAction action;
        if (!this.isInvalid(termOffset, termLength, length) && 0 != length && null != (action = this.scanForAvailableRetransmit(termId, termOffset, retransmitLength = flowControl.maxRetransmissionLength(termOffset, length, termLength, mtuLength)))) {
            action.termId = termId;
            action.termOffset = termOffset;
            action.length = retransmitLength;
            long delay = this.delayGenerator.generateDelayNs();
            if (0L == delay) {
                retransmitSender.resend(termId, termOffset, action.length);
                action.linger(this.lingerTimeoutGenerator.generateDelayNs(), this.nanoClock.nanoTime());
            } else {
                action.delay(delay, this.nanoClock.nanoTime());
            }
        }
    }

    public void onRetransmitReceived(int termId, int termOffset) {
        RetransmitAction action = this.scanForExistingRetransmit(termId, termOffset);
        if (null != action && RetransmitAction.State.DELAYED == action.state) {
            this.removeRetransmit(action);
        }
    }

    public void processTimeouts(long nowNs, RetransmitSender retransmitSender) {
        if (this.activeRetransmitCount > 0) {
            for (RetransmitAction action : this.retransmitActionPool) {
                if (RetransmitAction.State.DELAYED == action.state && action.expiryNs - nowNs < 0L) {
                    retransmitSender.resend(action.termId, action.termOffset, action.length);
                    action.linger(this.lingerTimeoutGenerator.generateDelayNs(), this.nanoClock.nanoTime());
                    continue;
                }
                if (RetransmitAction.State.LINGERING != action.state || action.expiryNs - nowNs >= 0L) continue;
                this.removeRetransmit(action);
            }
        }
    }

    private boolean isInvalid(int termOffset, int termLength, int length) {
        boolean isInvalid;
        boolean bl = isInvalid = termOffset > termLength - 32 || termOffset < 0 || length < 0;
        if (isInvalid) {
            this.invalidPackets.increment();
        }
        return isInvalid;
    }

    private RetransmitAction scanForAvailableRetransmit(int termId, int termOffset, int length) {
        if (0 == this.activeRetransmitCount) {
            return this.addRetransmit(this.retransmitActionPool[0]);
        }
        RetransmitAction availableAction = null;
        block4: for (RetransmitAction action : this.retransmitActionPool) {
            switch (action.state) {
                case INACTIVE: {
                    if (null != availableAction) continue block4;
                    availableAction = action;
                    continue block4;
                }
                case DELAYED: 
                case LINGERING: {
                    if (action.termId == termId && action.termOffset <= termOffset && termOffset < action.termOffset + action.length) {
                        return null;
                    }
                    if (this.hasGroupSemantics) continue block4;
                    availableAction = action;
                }
            }
        }
        if (this.hasGroupSemantics) {
            if (null != availableAction) {
                return this.addRetransmit(availableAction);
            }
            this.retransmitOverflowCounter.increment();
        }
        return availableAction;
    }

    private RetransmitAction scanForExistingRetransmit(int termId, int termOffset) {
        if (0 == this.activeRetransmitCount) {
            return null;
        }
        block3: for (RetransmitAction action : this.retransmitActionPool) {
            switch (action.state) {
                case DELAYED: 
                case LINGERING: {
                    if (action.termId != termId || action.termOffset != termOffset) continue block3;
                    return action;
                }
            }
        }
        return null;
    }

    private RetransmitAction addRetransmit(RetransmitAction retransmitAction) {
        ++this.activeRetransmitCount;
        return retransmitAction;
    }

    private void removeRetransmit(RetransmitAction action) {
        --this.activeRetransmitCount;
        action.cancel();
    }

    static final class RetransmitAction {
        long expiryNs;
        int termId;
        int termOffset;
        int length;
        State state = State.INACTIVE;

        RetransmitAction() {
        }

        void delay(long delayNs, long nowNs) {
            this.state = State.DELAYED;
            this.expiryNs = nowNs + delayNs;
        }

        void linger(long timeoutNs, long nowNs) {
            this.state = State.LINGERING;
            this.expiryNs = nowNs + timeoutNs;
        }

        void cancel() {
            this.state = State.INACTIVE;
        }

        static enum State {
            DELAYED,
            LINGERING,
            INACTIVE;

        }
    }
}

