/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.ext;

import io.aeron.driver.ext.LossGenerator;
import java.net.InetSocketAddress;
import org.agrona.BitUtil;
import org.agrona.collections.BiInt2ObjectMap;
import org.agrona.collections.MutableInteger;
import org.agrona.concurrent.UnsafeBuffer;

public class MultiGapLossGenerator
implements LossGenerator {
    private final int termId;
    private final int gapRadixBits;
    private final int gapRadixMask;
    private final int gapLength;
    private final int lastGapLimit;
    private final BiInt2ObjectMap<MutableInteger> streamAndSessionIdToOffsetMap = new BiInt2ObjectMap();

    public MultiGapLossGenerator(int termId, int gapRadix, int gapLength, int totalGaps) {
        int actualGapRadix = BitUtil.findNextPositivePowerOfTwo((int)gapRadix);
        if (gapLength >= actualGapRadix) {
            throw new IllegalArgumentException("gapLength must be smaller than gapRadix");
        }
        this.termId = termId;
        this.gapRadixBits = Integer.numberOfTrailingZeros(actualGapRadix);
        this.gapRadixMask = -actualGapRadix;
        this.gapLength = gapLength;
        this.lastGapLimit = totalGaps * actualGapRadix + gapLength;
    }

    @Override
    public boolean shouldDropFrame(InetSocketAddress address, UnsafeBuffer buffer, int length) {
        return false;
    }

    @Override
    public boolean shouldDropFrame(InetSocketAddress address, UnsafeBuffer buffer, int streamId, int sessionId, int termId, int termOffset, int length) {
        if (this.termId != termId) {
            return false;
        }
        if (termOffset > this.lastGapLimit) {
            return false;
        }
        MutableInteger maximumDroppedOffset = (MutableInteger)this.streamAndSessionIdToOffsetMap.get(streamId, sessionId);
        if (null == maximumDroppedOffset) {
            maximumDroppedOffset = new MutableInteger(termOffset);
            this.streamAndSessionIdToOffsetMap.put(streamId, sessionId, (Object)maximumDroppedOffset);
        }
        if (maximumDroppedOffset.get() > termOffset) {
            return false;
        }
        int frameLimit = termOffset + length;
        if (termOffset != 0 && Integer.numberOfTrailingZeros(termOffset) >= this.gapRadixBits) {
            maximumDroppedOffset.set(frameLimit);
            return true;
        }
        int previousGapOffset = termOffset & this.gapRadixMask;
        int previousGapLimit = previousGapOffset + this.gapLength;
        if (previousGapOffset > 0 && termOffset < previousGapLimit) {
            maximumDroppedOffset.set(frameLimit);
            return true;
        }
        int nextGapOffset = (termOffset >> this.gapRadixBits) + 1 << this.gapRadixBits;
        int nextGapLimit = nextGapOffset + this.gapLength;
        if (frameLimit > nextGapOffset && termOffset < nextGapLimit) {
            maximumDroppedOffset.set(frameLimit);
            return true;
        }
        return false;
    }
}

