/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.rest.client.response;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.apicurio.rest.client.error.RestClientErrorHandler;
import io.apicurio.rest.client.util.IoUtil;
import io.apicurio.rest.client.util.RegistryDateDeserializer;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.client.HttpResponse;
import java.util.Date;
import java.util.concurrent.CompletableFuture;

public class ResponseHandler<T>
implements Handler<AsyncResult<HttpResponse<Buffer>>> {
    final CompletableFuture<T> resultHolder;
    final TypeReference<T> targetType;
    final RestClientErrorHandler errorHandler;
    private static final ObjectMapper mapper = new ObjectMapper();

    public ResponseHandler(CompletableFuture<T> resultHolder, TypeReference<T> targetType, RestClientErrorHandler errorHandler) {
        this.resultHolder = resultHolder;
        this.targetType = targetType;
        this.errorHandler = errorHandler;
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public void handle(AsyncResult<HttpResponse<Buffer>> event) {
        try {
            if (event.result() != null && ResponseHandler.isFailure(((HttpResponse)event.result()).statusCode())) {
                if (((HttpResponse)event.result()).body() != null) {
                    this.resultHolder.completeExceptionally((Throwable)this.errorHandler.handleErrorResponse(IoUtil.toStream((byte[])((Buffer)((HttpResponse)event.result()).body()).getBytes()), ((HttpResponse)event.result()).statusCode()));
                } else {
                    this.resultHolder.completeExceptionally((Throwable)this.errorHandler.handleErrorResponse(null, ((HttpResponse)event.result()).statusCode()));
                }
            } else if (event.succeeded()) {
                HttpResponse result = (HttpResponse)event.result();
                String typeName = this.targetType.getType().getTypeName();
                if (typeName.contains("InputStream")) {
                    this.resultHolder.complete(IoUtil.toStream((byte[])((Buffer)result.body()).getBytes()));
                } else if (typeName.contains("Void")) {
                    this.resultHolder.complete(null);
                } else {
                    this.resultHolder.complete(mapper.readValue(((Buffer)result.body()).getBytes(), this.targetType));
                }
            } else {
                this.resultHolder.completeExceptionally(event.cause());
            }
        }
        catch (Exception e) {
            this.resultHolder.completeExceptionally(e);
        }
    }

    private static boolean isFailure(int statusCode) {
        return statusCode / 100 != 2;
    }

    static {
        SimpleModule module = new SimpleModule("Custom date handler");
        module.addDeserializer(Date.class, (JsonDeserializer)new RegistryDateDeserializer());
        mapper.registerModule((Module)module);
    }
}

