/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.deref;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.deref.ReferencedNodeImporter;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.Parameter;
import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.openapi.OpenApiPathItem;
import io.apicurio.datamodels.models.openapi.OpenApiResponse;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Definitions;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Document;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Items;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Parameter;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20ParameterDefinitions;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Response;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20ResponseDefinitions;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Schema;

public class OpenApi2NodeImporter
extends ReferencedNodeImporter {
    public OpenApi2NodeImporter(Document doc, Node nodeWithUnresolvedRef, String ref, boolean shouldInline) {
        super(doc, nodeWithUnresolvedRef, ref, shouldInline);
    }

    @Override
    public void visitItems(OpenApi20Items node) {
        ObjectNode json = Library.writeNode(node);
        Library.readNode(json, this.getNodeWithUnresolvedRef());
        this.setPathToImportedNode(this.getNodeWithUnresolvedRef(), null);
    }

    @Override
    public void visitParameter(Parameter node) {
        String collection = "parameters";
        if (this.shouldInline()) {
            this.inlineDefinition(collection, node);
        } else {
            OpenApi20Document doc = (OpenApi20Document)this.getDoc();
            OpenApi20ParameterDefinitions params = doc.getParameters();
            if (params == null) {
                params = doc.createParameterDefinitions();
                doc.setParameters(params);
            }
            String name = this.generateNodeName(this.getNameHintFromRef("ImportedParameter"), params.getItemNames());
            params.addItem(name, (OpenApi20Parameter)node);
            node.attach(params);
            this.setPathToImportedNode(node, collection, name);
        }
    }

    @Override
    public void visitPathItem(OpenApiPathItem node) {
        ObjectNode json = Library.writeNode(node);
        Library.readNode(json, this.getNodeWithUnresolvedRef());
        this.setPathToImportedNode(this.getNodeWithUnresolvedRef(), null);
    }

    @Override
    public void visitResponse(OpenApiResponse node) {
        String collection = "responses";
        if (this.shouldInline()) {
            this.inlineDefinition(collection, node);
        } else {
            OpenApi20Document doc = (OpenApi20Document)this.getDoc();
            OpenApi20ResponseDefinitions responses = doc.getResponses();
            if (responses == null) {
                responses = doc.createResponseDefinitions();
                doc.setResponses(responses);
            }
            String name = this.generateNodeName(this.getNameHintFromRef("ImportedResponse"), responses.getItemNames());
            responses.addItem(name, (OpenApi20Response)node);
            node.attach(responses);
            this.setPathToImportedNode(node, collection, name);
        }
    }

    @Override
    public void visitSchema(Schema node) {
        String collection = "definitions";
        if (this.shouldInline()) {
            this.inlineDefinition(collection, node);
        } else {
            OpenApi20Document doc = (OpenApi20Document)this.getDoc();
            OpenApi20Definitions definitions = doc.getDefinitions();
            if (definitions == null) {
                definitions = doc.createDefinitions();
                doc.setDefinitions(definitions);
            }
            String name = this.generateNodeName(this.getNameHintFromRef("ImportedSchema"), definitions.getItemNames());
            definitions.addItem(name, (OpenApi20Schema)node);
            node.attach(definitions);
            this.setPathToImportedNode(node, collection, name);
        }
    }

    @Override
    protected void setPathToImportedNode(Node importedNode, String collection, String name) {
        this.setPathToImportedNode(importedNode, "#/" + collection + "/" + name);
    }

    private void inlineDefinition(String collection, Node node) {
        this.inlineComponent(collection, node);
    }
}

