/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.refs;

import io.apicurio.datamodels.models.MappedNode;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.refs.IReferenceResolver;
import io.apicurio.datamodels.util.NodeUtil;
import io.apicurio.datamodels.util.RegexUtil;
import java.util.List;

public class LocalReferenceResolver
implements IReferenceResolver {
    @Override
    public Node resolveRef(String $ref, Node from) {
        if ($ref == null || $ref.indexOf("#/") != 0) {
            return null;
        }
        List<String[]> split = RegexUtil.findMatches($ref, "([^/]+)/?");
        Object cnode = null;
        for (String[] mi : split) {
            String seg = mi[1];
            if (NodeUtil.equals(seg, "#")) {
                cnode = from.root();
                continue;
            }
            if (cnode == null) continue;
            if (cnode instanceof MappedNode) {
                cnode = ((MappedNode)cnode).getItem(seg);
                continue;
            }
            cnode = NodeUtil.getProperty(cnode, seg);
        }
        if (cnode instanceof Node) {
            return (Node)cnode;
        }
        return null;
    }
}

