/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.util;

import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.union.Union;
import io.apicurio.datamodels.visitors.DefinitionDetectionVisitor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class NodeUtil {
    public static Object getProperty(Object node, String propertyName) {
        if (NodeUtil.isNode(node)) {
            return NodeUtil.getNodeProperty((Node)node, propertyName);
        }
        if (node instanceof List) {
            int idx = Integer.parseInt(propertyName);
            List list = (List)node;
            return list.get(idx);
        }
        if (node instanceof Map) {
            Map map = (Map)node;
            return map.get(propertyName);
        }
        return null;
    }

    public static Object getNodeProperty(Node node, String propertyName) {
        String getterName = "get" + StringUtils.capitalize((String)propertyName);
        try {
            Method method = node.getClass().getMethod(getterName, new Class[0]);
            return method.invoke((Object)node, new Object[0]);
        }
        catch (NoSuchMethodException method) {
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e1) {
            return null;
        }
        getterName = "is" + StringUtils.capitalize((String)propertyName);
        try {
            Method method = node.getClass().getMethod(getterName, new Class[0]);
            return method.invoke((Object)node, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e1) {
            return null;
        }
    }

    public static boolean isNode(Object object) {
        return object != null && object instanceof Node;
    }

    public static boolean isDefinition(Node node) {
        DefinitionDetectionVisitor detector = new DefinitionDetectionVisitor();
        if (node.parent() != null) {
            node.parent().accept(detector);
        }
        return detector.isDefinitionParentDetected();
    }

    public static boolean isUnion(Object object) {
        return object != null && object instanceof Union;
    }

    public static boolean isList(Object object) {
        return object != null && object instanceof List;
    }

    public static boolean isMap(Object object) {
        return object != null && object instanceof Map;
    }

    public static Object getMapItem(Map map, String key) {
        return map.get(key);
    }

    public static int toInteger(String value) {
        return Integer.parseInt(value);
    }

    public static boolean isNullOrUndefined(Object value) {
        return value == null;
    }

    public static boolean isDefined(Object value) {
        return !NodeUtil.isNullOrUndefined(value);
    }

    public static List<String> asList(String ... items) {
        return Arrays.asList(items);
    }

    public static String[] asArray(List<String> list) {
        return list.toArray(new String[list.size()]);
    }

    public static List<String> copyList(List<String> list) {
        ArrayList<String> rval = new ArrayList<String>();
        rval.addAll(list);
        return rval;
    }

    public static boolean equals(Object value1, Object value2) {
        if (value1 == value2) {
            return true;
        }
        return value1 != null && value1.equals(value2);
    }

    public static Collection<String> getMapKeys(Map<String, ?> map) {
        if (map == null) {
            return Collections.emptyList();
        }
        return map.keySet();
    }

    public static <T> Collection<T> getMapValues(Map<String, T> map) {
        if (map == null) {
            return Collections.emptyList();
        }
        return map.values();
    }
}

