/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.invalid.type;

import io.apicurio.datamodels.models.Schema;
import io.apicurio.datamodels.models.openapi.v20.OpenApi20Schema;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Schema;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Schema;
import io.apicurio.datamodels.models.union.StringStringListUnion;
import io.apicurio.datamodels.validation.ValidationRule;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;

public abstract class OasInvalidPropertyTypeValidationRule
extends ValidationRule {
    protected static final String[] ALLOWED_TYPES = new String[]{"string", "number", "integer", "boolean", "array", "object"};
    protected static final String[] ALLOWED_TYPES31 = new String[]{"string", "number", "integer", "boolean", "array", "object", "null"};

    public OasInvalidPropertyTypeValidationRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    static List<String> toList(String type) {
        return type != null ? Collections.singletonList(type) : Collections.emptyList();
    }

    static List<String> toList(StringStringListUnion types) {
        if (types != null) {
            return types.isString() ? Collections.singletonList(types.asString()) : types.asStringList();
        }
        return Collections.emptyList();
    }

    public static void getTypes(Schema node, BiConsumer<List<String>, String[]> handler) {
        List<String> types;
        String[] allowedTypes;
        if (node instanceof OpenApi31Schema) {
            allowedTypes = ALLOWED_TYPES31;
            types = OasInvalidPropertyTypeValidationRule.toList(((OpenApi31Schema)node).getType());
        } else if (node instanceof OpenApi30Schema) {
            allowedTypes = ALLOWED_TYPES;
            types = OasInvalidPropertyTypeValidationRule.toList(((OpenApi30Schema)node).getType());
        } else if (node instanceof OpenApi20Schema) {
            allowedTypes = ALLOWED_TYPES;
            types = OasInvalidPropertyTypeValidationRule.toList(((OpenApi20Schema)node).getType());
        } else {
            allowedTypes = null;
            types = Collections.emptyList();
        }
        handler.accept(types, allowedTypes);
    }
}

