/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.maven.refs;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rest.client.models.VersionMetaData;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Set;

public class IndexedResource {
    private final Path path;
    private final String type;
    private final String resourceName;
    private final ContentHandle content;
    private VersionMetaData registration;

    public IndexedResource(Path path, String type, String resourceName, ContentHandle content) {
        this.path = path;
        this.content = content;
        this.type = type;
        this.resourceName = resourceName;
    }

    public ContentHandle getContent() {
        return this.content;
    }

    public String getType() {
        return this.type;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public Path getPath() {
        return this.path;
    }

    public boolean matches(String resourceName, Path relativeToFile, Set<Path> schemaPaths) {
        if (this.path == null) {
            return this.resourceName.equals(resourceName);
        }
        if ("AVRO".equals(this.type) && this.resourceName.equals(resourceName)) {
            return true;
        }
        Path resolvedPath = relativeToFile.getParent().resolve(resourceName);
        boolean resolves = this.path.normalize().equals(resolvedPath.normalize());
        if (!resolves && "PROTOBUF".equals(this.type)) {
            resolves = schemaPaths.parallelStream().anyMatch(path -> this.path.normalize().equals(path.resolve(resourceName).normalize()));
        }
        return resolves;
    }

    public VersionMetaData getRegistration() {
        return this.registration;
    }

    public void setRegistration(VersionMetaData registration) {
        this.registration = registration;
    }

    public boolean isRegistered() {
        return this.registration != null;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexedResource that = (IndexedResource)o;
        return Objects.equals(this.path, that.path) && Objects.equals(this.registration, that.registration);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.registration);
    }
}

