/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.validity;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.rest.v2.beans.ArtifactReference;
import io.apicurio.registry.rules.RuleViolation;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.rules.integrity.IntegrityLevel;
import io.apicurio.registry.rules.validity.ContentValidator;
import io.apicurio.registry.rules.validity.ValidityLevel;
import io.apicurio.registry.types.RuleType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;

public class AvroContentValidator
implements ContentValidator {
    private static final String DUMMY_AVRO_RECORD = "{\n     \"type\": \"record\",\n     \"namespace\": \"NAMESPACE\",\n     \"name\": \"NAME\",\n     \"fields\": [\n       { \"name\": \"first\", \"type\": \"string\" },\n       { \"name\": \"last\", \"type\": \"string\" }\n     ]\n}";

    public void validate(ValidityLevel level, ContentHandle artifactContent, Map<String, ContentHandle> resolvedReferences) throws RuleViolationException {
        if (level == ValidityLevel.SYNTAX_ONLY || level == ValidityLevel.FULL) {
            try {
                Schema.Parser parser = new Schema.Parser();
                for (ContentHandle schema : resolvedReferences.values()) {
                    parser.parse(schema.content());
                }
                parser.parse(artifactContent.content());
            }
            catch (Exception e) {
                throw new RuleViolationException("Syntax violation for Avro artifact.", RuleType.VALIDITY, level.name(), (Throwable)e);
            }
        }
    }

    public void validateReferences(ContentHandle artifactContent, List<ArtifactReference> references) throws RuleViolationException {
        block2: {
            try {
                Schema.Parser parser = new Schema.Parser();
                references.forEach(ref -> {
                    String refName = ref.getName();
                    if (refName != null && refName.contains(".")) {
                        int idx = refName.lastIndexOf(46);
                        String ns = refName.substring(0, idx);
                        String name = refName.substring(idx + 1);
                        parser.parse(DUMMY_AVRO_RECORD.replace("NAMESPACE", ns).replace("NAME", name));
                    }
                });
                parser.parse(artifactContent.content());
            }
            catch (Exception e) {
                if (!e.getMessage().contains("is not a defined name")) break block2;
                RuleViolation violation = new RuleViolation("Missing reference detected.", e.getMessage());
                throw new RuleViolationException("Missing reference detected in Avro artifact.", RuleType.INTEGRITY, IntegrityLevel.ALL_REFS_MAPPED.name(), Collections.singleton(violation));
            }
        }
    }
}

