/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility.jsonschema.diff;

import io.apicurio.registry.rules.compatibility.jsonschema.JsonSchemaWrapperVisitor;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffContext;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffType;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffUtil;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.SchemaDiffVisitor;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.ReferenceSchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.SchemaWrapper;
import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;

public class ReferenceSchemaDiffVisitor
extends JsonSchemaWrapperVisitor {
    private DiffContext ctx;
    private final Schema referredOriginal;

    public ReferenceSchemaDiffVisitor(DiffContext ctx, Schema original) {
        this.ctx = ctx;
        this.referredOriginal = original instanceof ReferenceSchema ? ((ReferenceSchema)original).getReferredSchema() : original;
    }

    @Override
    public void visitReferenceSchema(ReferenceSchemaWrapper referenceSchema) {
        if (!this.ctx.visited.contains(referenceSchema.getLocation())) {
            this.ctx.visited.add(referenceSchema.getLocation());
            this.ctx = this.ctx.sub("[ref " + referenceSchema.getLocation() + "]");
            super.visitReferenceSchema(referenceSchema);
        } else {
            this.ctx.log("Reference recursion circuit breaker activated at: " + this.ctx.getPathUpdated());
        }
    }

    @Override
    public void visitReferredSchema(SchemaWrapper schema) {
        if (DiffUtil.diffSubschemaAddedRemoved(this.ctx, this.referredOriginal, schema, DiffType.REFERENCE_TYPE_TARGET_SCHEMA_ADDED, DiffType.REFERENCE_TYPE_TARGET_SCHEMA_REMOVED)) {
            schema.accept(new SchemaDiffVisitor(this.ctx, this.referredOriginal));
        }
        super.visitReferredSchema(schema);
    }
}

