/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client;

import com.google.common.base.Strings;
import io.appium.java_client.AppiumClientConfig;
import io.appium.java_client.AppiumCommandInfo;
import io.appium.java_client.AppiumExecutionMethod;
import io.appium.java_client.CanRememberExtensionPresence;
import io.appium.java_client.ComparesImages;
import io.appium.java_client.ErrorCodesMobile;
import io.appium.java_client.ExecutesDriverScript;
import io.appium.java_client.ExecutesMethod;
import io.appium.java_client.HasBrowserCheck;
import io.appium.java_client.HasSettings;
import io.appium.java_client.LogsEvents;
import io.appium.java_client.MobileCommand;
import io.appium.java_client.internal.CapabilityHelpers;
import io.appium.java_client.internal.SessionHelpers;
import io.appium.java_client.remote.AppiumCommandExecutor;
import io.appium.java_client.remote.AppiumW3CHttpCommandCodec;
import io.appium.java_client.remote.options.BaseOptions;
import io.appium.java_client.service.local.AppiumDriverLocalService;
import io.appium.java_client.service.local.AppiumServiceBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.UnsupportedCommandException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.BiDiException;
import org.openqa.selenium.bidi.Connection;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.remote.CommandCodec;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DriverCommand;
import org.openqa.selenium.remote.ErrorCodes;
import org.openqa.selenium.remote.ErrorHandler;
import org.openqa.selenium.remote.ExecuteMethod;
import org.openqa.selenium.remote.HttpCommandExecutor;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.ResponseCodec;
import org.openqa.selenium.remote.codec.w3c.W3CHttpResponseCodec;
import org.openqa.selenium.remote.html5.RemoteLocationContext;
import org.openqa.selenium.remote.http.ClientConfig;
import org.openqa.selenium.remote.http.HttpClient;
import org.openqa.selenium.remote.http.HttpMethod;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.service.DriverService;

public class AppiumDriver
extends RemoteWebDriver
implements ExecutesMethod,
ComparesImages,
ExecutesDriverScript,
LogsEvents,
HasBrowserCheck,
CanRememberExtensionPresence,
HasSettings,
HasBiDi {
    private static final ErrorHandler ERROR_HANDLER = new ErrorHandler((ErrorCodes)new ErrorCodesMobile(), true);
    private final URL remoteAddress;
    @Deprecated(forRemoval=true)
    protected final RemoteLocationContext locationContext;
    private final ExecuteMethod executeMethod;
    private final Set<String> absentExtensionNames = new HashSet<String>();
    private URI biDiUri;
    private BiDi biDi;
    private boolean wasBiDiRequested = false;

    public AppiumDriver(HttpCommandExecutor executor, Capabilities capabilities) {
        super((CommandExecutor)executor, capabilities);
        this.executeMethod = new AppiumExecutionMethod(this);
        this.locationContext = new RemoteLocationContext(this.executeMethod);
        super.setErrorHandler(ERROR_HANDLER);
        this.remoteAddress = executor.getAddressOfRemoteServer();
    }

    public AppiumDriver(AppiumClientConfig clientConfig, Capabilities capabilities) {
        this(new AppiumCommandExecutor(MobileCommand.commandRepository, clientConfig), capabilities);
    }

    public AppiumDriver(URL remoteAddress, Capabilities capabilities) {
        this(new AppiumCommandExecutor(MobileCommand.commandRepository, remoteAddress), capabilities);
    }

    public AppiumDriver(URL remoteAddress, HttpClient.Factory httpClientFactory, Capabilities capabilities) {
        this(new AppiumCommandExecutor(MobileCommand.commandRepository, remoteAddress, httpClientFactory), capabilities);
    }

    public AppiumDriver(AppiumDriverLocalService service, Capabilities capabilities) {
        this(new AppiumCommandExecutor(MobileCommand.commandRepository, service), capabilities);
    }

    public AppiumDriver(AppiumDriverLocalService service, HttpClient.Factory httpClientFactory, Capabilities capabilities) {
        this(new AppiumCommandExecutor(MobileCommand.commandRepository, (DriverService)service, httpClientFactory), capabilities);
    }

    public AppiumDriver(AppiumServiceBuilder builder, Capabilities capabilities) {
        this((AppiumDriverLocalService)builder.build(), capabilities);
    }

    public AppiumDriver(AppiumServiceBuilder builder, HttpClient.Factory httpClientFactory, Capabilities capabilities) {
        this((AppiumDriverLocalService)builder.build(), httpClientFactory, capabilities);
    }

    public AppiumDriver(HttpClient.Factory httpClientFactory, Capabilities capabilities) {
        this(AppiumDriverLocalService.buildDefaultService(), httpClientFactory, capabilities);
    }

    public AppiumDriver(Capabilities capabilities) {
        this(AppiumDriverLocalService.buildDefaultService(), capabilities);
    }

    public AppiumDriver(URL remoteSessionAddress, String platformName, String automationName) {
        this.capabilities = new ImmutableCapabilities(Map.of("platformName", platformName, "appium:automationName", automationName));
        SessionHelpers.SessionAddress sessionAddress = SessionHelpers.parseSessionAddress(remoteSessionAddress);
        AppiumCommandExecutor executor = new AppiumCommandExecutor(MobileCommand.commandRepository, sessionAddress.getServerUrl());
        executor.setCommandCodec((CommandCodec<HttpRequest>)new AppiumW3CHttpCommandCodec());
        executor.setResponseCodec((ResponseCodec<HttpResponse>)new W3CHttpResponseCodec());
        this.setCommandExecutor((CommandExecutor)executor);
        this.executeMethod = new AppiumExecutionMethod(this);
        this.locationContext = new RemoteLocationContext(this.executeMethod);
        super.setErrorHandler(ERROR_HANDLER);
        this.remoteAddress = executor.getAddressOfRemoteServer();
        this.setSessionId(sessionAddress.getId());
    }

    public ExecuteMethod getExecuteMethod() {
        return this.executeMethod;
    }

    public Map<String, Object> getStatus() {
        return (Map)this.execute("status").getValue();
    }

    public void addCommand(HttpMethod httpMethod, String url, String methodName) {
        AppiumCommandInfo commandInfo;
        switch (httpMethod) {
            case GET: {
                commandInfo = MobileCommand.getC(url);
                break;
            }
            case POST: {
                commandInfo = MobileCommand.postC(url);
                break;
            }
            case DELETE: {
                commandInfo = MobileCommand.deleteC(url);
                break;
            }
            default: {
                throw new WebDriverException(String.format("Unsupported HTTP Method: %s. Only %s methods are supported", httpMethod, Arrays.toString(HttpMethod.values())));
            }
        }
        ((AppiumCommandExecutor)this.getCommandExecutor()).defineCommand(methodName, commandInfo);
    }

    @Override
    public Response execute(String driverCommand, Map<String, ?> parameters) {
        return super.execute(driverCommand, parameters);
    }

    @Override
    public Response execute(String command) {
        return super.execute(command, Collections.emptyMap());
    }

    public <X> X getScreenshotAs(final OutputType<X> outputType) {
        return (X)super.getScreenshotAs(new OutputType<X>(){

            public X convertFromBase64Png(String base64Png) {
                String rfc4648Base64 = base64Png.replaceAll("\\r?\\n", "");
                return outputType.convertFromBase64Png(rfc4648Base64);
            }

            public X convertFromPngBytes(byte[] png) {
                return outputType.convertFromPngBytes(png);
            }
        });
    }

    @Override
    public AppiumDriver assertExtensionExists(String extName) {
        if (this.absentExtensionNames.contains(extName)) {
            throw new UnsupportedCommandException();
        }
        return this;
    }

    @Override
    public AppiumDriver markExtensionAbsence(String extName) {
        this.absentExtensionNames.add(extName);
        return this;
    }

    public Optional<BiDi> maybeGetBiDi() {
        return Optional.ofNullable(this.biDi);
    }

    @Nonnull
    public BiDi getBiDi() {
        Object webSocketUrl = ((BaseOptions)this.capabilities).getWebSocketUrl().orElseThrow(() -> {
            String suffix = this.wasBiDiRequested ? "Do both the server and the driver declare BiDi support?" : String.format("Did you set %s to true?", "webSocketUrl");
            return new BiDiException(String.format("BiDi is not enabled for this driver session. %s", suffix));
        });
        if (this.biDiUri == null) {
            throw new BiDiException(String.format("BiDi is not enabled for this driver session. Is the %s '%s' received from the create session response valid?", "webSocketUrl", webSocketUrl));
        }
        if (this.biDi == null) {
            throw new IllegalStateException();
        }
        return this.biDi;
    }

    protected HttpClient getHttpClient() {
        return ((HttpCommandExecutor)this.getCommandExecutor()).client;
    }

    protected void startSession(Capabilities requestCapabilities) {
        Response response = Optional.ofNullable(this.execute(DriverCommand.NEW_SESSION(Collections.singleton(requestCapabilities)))).orElseThrow(() -> new SessionNotCreatedException("The underlying command executor returned a null response."));
        Map rawResponseCapabilities = Optional.ofNullable(response.getValue()).map(value -> {
            if (!(value instanceof Map)) {
                throw new SessionNotCreatedException(String.format("The underlying command executor returned a response with a non well formed payload: %s", response));
            }
            return (Map)value;
        }).orElseThrow(() -> new SessionNotCreatedException("The underlying command executor returned a response without payload: " + response));
        rawResponseCapabilities.remove("platform");
        if (rawResponseCapabilities.containsKey("browserName") && Strings.isNullOrEmpty((String)((String)rawResponseCapabilities.get("browserName")))) {
            rawResponseCapabilities.remove("browserName");
        }
        this.capabilities = new BaseOptions(rawResponseCapabilities);
        this.wasBiDiRequested = Boolean.TRUE.equals(requestCapabilities.getCapability("webSocketUrl"));
        if (this.wasBiDiRequested) {
            this.initBiDi((BaseOptions)this.capabilities);
        }
        this.setSessionId(response.getSessionId());
    }

    protected static Capabilities ensurePlatformName(Capabilities originalCapabilities, String defaultName) {
        return originalCapabilities.getPlatformName() == null ? originalCapabilities.merge((Capabilities)new ImmutableCapabilities("platformName", (Object)defaultName)) : originalCapabilities;
    }

    protected static Capabilities ensureAutomationName(Capabilities originalCapabilities, String defaultName) {
        String currentAutomationName = CapabilityHelpers.getCapability(originalCapabilities, "automationName", String.class);
        if (Strings.isNullOrEmpty((String)currentAutomationName)) {
            String capabilityName = originalCapabilities.getCapabilityNames().contains("automationName") ? "automationName" : "appium:automationName";
            return originalCapabilities.merge((Capabilities)new ImmutableCapabilities(capabilityName, (Object)defaultName));
        }
        return originalCapabilities;
    }

    protected static Capabilities ensurePlatformAndAutomationNames(Capabilities originalCapabilities, String defaultPlatformName, String defaultAutomationName) {
        Capabilities capsWithPlatformFixed = AppiumDriver.ensurePlatformName(originalCapabilities, defaultPlatformName);
        return AppiumDriver.ensureAutomationName(capsWithPlatformFixed, defaultAutomationName);
    }

    private void initBiDi(BaseOptions<?> responseCaps) {
        HttpClient wsClient;
        AppiumClientConfig wsConfig;
        Optional webSocketUrl = responseCaps.getWebSocketUrl();
        if (webSocketUrl.isEmpty()) {
            return;
        }
        URISyntaxException uriSyntaxError = null;
        try {
            this.biDiUri = new URI(String.valueOf(webSocketUrl.get()));
        }
        catch (URISyntaxException e) {
            uriSyntaxError = e;
        }
        if (uriSyntaxError != null || this.biDiUri.getScheme() == null) {
            String message = String.format("BiDi cannot be enabled for this driver session. Is the %s '%s' received from the create session response valid?", "webSocketUrl", webSocketUrl.get());
            if (uriSyntaxError == null) {
                throw new BiDiException(message);
            }
            throw new BiDiException(message, (Throwable)uriSyntaxError);
        }
        CommandExecutor executor = this.getCommandExecutor();
        if (executor instanceof AppiumCommandExecutor) {
            wsConfig = ((AppiumCommandExecutor)executor).getAppiumClientConfig().baseUri(this.biDiUri);
            wsClient = ((AppiumCommandExecutor)executor).getHttpClientFactory().createClient((ClientConfig)wsConfig);
        } else {
            wsConfig = AppiumClientConfig.defaultConfig().baseUri(this.biDiUri);
            wsClient = HttpClient.Factory.createDefault().createClient((ClientConfig)wsConfig);
        }
        Connection biDiConnection = new Connection(wsClient, this.biDiUri.toString());
        this.biDi = new BiDi(biDiConnection);
    }

    @Generated
    public URL getRemoteAddress() {
        return this.remoteAddress;
    }
}

