/*
 * Decompiled with CFR 0.152.
 */
package io.appium.java_client.remote;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lombok.Generated;

public class DirectConnect {
    private static final String DIRECT_CONNECT_PROTOCOL = "directConnectProtocol";
    private static final String DIRECT_CONNECT_PATH = "directConnectPath";
    private static final String DIRECT_CONNECT_HOST = "directConnectHost";
    private static final String DIRECT_CONNECT_PORT = "directConnectPort";
    private final String protocol;
    private final String path;
    private final String host;
    private final String port;

    public DirectConnect(Map<String, ?> responseValue) {
        this.protocol = this.getDirectConnectValue(responseValue, DIRECT_CONNECT_PROTOCOL);
        this.path = this.getDirectConnectValue(responseValue, DIRECT_CONNECT_PATH);
        this.host = this.getDirectConnectValue(responseValue, DIRECT_CONNECT_HOST);
        this.port = this.getDirectConnectValue(responseValue, DIRECT_CONNECT_PORT);
    }

    @Nullable
    private String getDirectConnectValue(Map<String, ?> responseValue, String key) {
        Object directConnectPath = responseValue.get("appium:" + key);
        if (directConnectPath != null) {
            return String.valueOf(directConnectPath);
        }
        directConnectPath = responseValue.get(key);
        return directConnectPath == null ? null : String.valueOf(directConnectPath);
    }

    public boolean isValid() {
        return Stream.of(this.protocol, this.path, this.host, this.port).noneMatch(Objects::isNull);
    }

    public URL getUrl() throws MalformedURLException {
        String newUrlCandidate = String.format("%s://%s:%s%s", this.protocol, this.host, this.port, this.path);
        try {
            return new URL(newUrlCandidate);
        }
        catch (MalformedURLException e) {
            throw new MalformedURLException(String.format("The remote server returned an invalid value to build the direct connect URL: %s", newUrlCandidate));
        }
    }

    @Generated
    public String getProtocol() {
        return this.protocol;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public String getPort() {
        return this.port;
    }
}

