/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.authentication;

import io.asyncer.r2dbc.mysql.authentication.CachingSha2FastAuthProvider;
import io.asyncer.r2dbc.mysql.authentication.MySqlClearAuthProvider;
import io.asyncer.r2dbc.mysql.authentication.MySqlNativeAuthProvider;
import io.asyncer.r2dbc.mysql.authentication.NoAuthProvider;
import io.asyncer.r2dbc.mysql.authentication.OldAuthProvider;
import io.asyncer.r2dbc.mysql.authentication.Sha256AuthProvider;
import io.asyncer.r2dbc.mysql.collation.CharCollation;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.r2dbc.spi.R2dbcPermissionDeniedException;
import org.jetbrains.annotations.Nullable;

public interface MySqlAuthProvider {
    public static final String CACHING_SHA2_PASSWORD = "caching_sha2_password";
    public static final String MYSQL_NATIVE_PASSWORD = "mysql_native_password";
    public static final String SHA256_PASSWORD = "sha256_password";
    public static final String MYSQL_OLD_PASSWORD = "mysql_old_password";
    public static final String MYSQL_CLEAR_PASSWORD = "mysql_clear_password";
    public static final String NO_AUTH_PROVIDER = "";

    public static MySqlAuthProvider build(String type) {
        AssertUtils.requireNonNull(type, "type must not be null");
        switch (type) {
            case "caching_sha2_password": {
                return CachingSha2FastAuthProvider.getInstance();
            }
            case "mysql_native_password": {
                return MySqlNativeAuthProvider.getInstance();
            }
            case "mysql_clear_password": {
                return MySqlClearAuthProvider.getInstance();
            }
            case "sha256_password": {
                return Sha256AuthProvider.getInstance();
            }
            case "mysql_old_password": {
                return OldAuthProvider.getInstance();
            }
            case "": {
                return NoAuthProvider.getInstance();
            }
        }
        throw new R2dbcPermissionDeniedException("Authentication plugin '" + type + "' not found");
    }

    public String getType();

    public boolean isSslNecessary();

    public byte[] authentication(@Nullable CharSequence var1, byte[] var2, CharCollation var3);

    public MySqlAuthProvider next();
}

