/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.cache;

import io.asyncer.r2dbc.mysql.cache.Caches;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;

final class FreqSketch {
    private static final long[] SEED = new long[]{-4348849565147123417L, -5435081209227447693L, -7286425919675154353L, -3750763034362895579L};
    private static final long RESET_MASK = 0x7777777777777777L;
    private static final long ONE_MASK = 0x1111111111111111L;
    private static final int MAX_SIZE = 0x40000000;
    private final long[] table;
    private final int tableMask;
    private final int sampling;
    private int size;

    FreqSketch(int maxSize) {
        AssertUtils.require(maxSize > 0, "maxSize must be a positive integer");
        int capacity = Math.min(maxSize, 0x40000000);
        int sampling = capacity * 10;
        int length = Caches.ceilingPowerOfTwo(capacity);
        this.table = new long[length];
        this.tableMask = length - 1;
        this.sampling = sampling > 0 ? sampling : Integer.MAX_VALUE;
        this.size = 0;
    }

    int frequency(int hashCode) {
        int hash = FreqSketch.spread(hashCode);
        int start = (hash & 3) << 2;
        int frequency = Integer.MAX_VALUE;
        for (int i = 0; i < 4; ++i) {
            int index = this.indexOf(hash, i);
            frequency = Math.min(frequency, (int)(this.table[index] >>> (start + i << 2) & 0xFL));
        }
        return frequency;
    }

    void increment(int hashCode) {
        int hash = FreqSketch.spread(hashCode);
        int start = (hash & 3) << 2;
        int index0 = this.indexOf(hash, 0);
        int index1 = this.indexOf(hash, 1);
        int index2 = this.indexOf(hash, 2);
        int index3 = this.indexOf(hash, 3);
        boolean added = this.incrementAt(index0, start);
        added |= this.incrementAt(index1, start + 1);
        added |= this.incrementAt(index2, start + 2);
        if ((added |= this.incrementAt(index3, start + 3)) && ++this.size == this.sampling) {
            this.reset();
        }
    }

    private boolean incrementAt(int i, int j) {
        int offset = j << 2;
        long mask = 15L << offset;
        if ((this.table[i] & mask) != mask) {
            int n = i;
            this.table[n] = this.table[n] + (1L << offset);
            return true;
        }
        return false;
    }

    private void reset() {
        int count = 0;
        for (int i = 0; i < this.table.length; ++i) {
            count += Long.bitCount(this.table[i] & 0x1111111111111111L);
            this.table[i] = this.table[i] >>> 1 & 0x7777777777777777L;
        }
        this.size = (this.size >>> 1) - (count >>> 2);
    }

    private int indexOf(int item, int i) {
        long hash = ((long)item + SEED[i]) * SEED[i];
        return (int)(hash + (hash >>> 32)) & this.tableMask;
    }

    private static int spread(int x) {
        x = (x >>> 16 ^ x) * 73244475;
        x = (x >>> 16 ^ x) * 73244475;
        return x >>> 16 ^ x;
    }
}

