/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.message.server;

import io.asyncer.r2dbc.mysql.Capability;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.message.server.HandshakeHeader;
import io.asyncer.r2dbc.mysql.message.server.HandshakeRequest;
import io.asyncer.r2dbc.mysql.message.server.ServerStatusMessage;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

final class HandshakeV10Request
implements HandshakeRequest,
ServerStatusMessage {
    private static final int RESERVED_SIZE = 6;
    private static final int MARIA_DB_CAPABILITY_SIZE = 4;
    private static final int SALT_FIRST_PART_SIZE = 8;
    private static final int MIN_SALT_SECOND_PART_SIZE = 12;
    private final HandshakeHeader header;
    private final int envelopeId;
    private final byte[] salt;
    private final Capability serverCapability;
    private final short serverStatuses;
    private final String authType;

    private HandshakeV10Request(HandshakeHeader header, int envelopeId, byte[] salt, Capability serverCapability, short serverStatuses, String authType) {
        this.header = AssertUtils.requireNonNull(header, "header must not be null");
        this.envelopeId = envelopeId;
        this.salt = AssertUtils.requireNonNull(salt, "salt must not be null");
        this.serverCapability = AssertUtils.requireNonNull(serverCapability, "serverCapability must not be null");
        this.serverStatuses = serverStatuses;
        this.authType = AssertUtils.requireNonNull(authType, "authType must not be null");
    }

    @Override
    public HandshakeHeader getHeader() {
        return this.header;
    }

    @Override
    public int getEnvelopeId() {
        return this.envelopeId;
    }

    @Override
    public byte[] getSalt() {
        return this.salt;
    }

    @Override
    public Capability getServerCapability() {
        return this.serverCapability;
    }

    @Override
    public short getServerStatuses() {
        return this.serverStatuses;
    }

    @Override
    public String getAuthType() {
        return this.authType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HandshakeV10Request that = (HandshakeV10Request)o;
        return this.envelopeId == that.envelopeId && this.serverStatuses == that.serverStatuses && this.header.equals(that.header) && Arrays.equals(this.salt, that.salt) && this.serverCapability.equals(that.serverCapability) && this.authType.equals(that.authType);
    }

    public int hashCode() {
        int hash = 31 * this.header.hashCode() + this.envelopeId;
        hash = 31 * hash + Arrays.hashCode(this.salt);
        hash = 31 * hash + this.serverCapability.hashCode();
        hash = 31 * hash + this.serverStatuses;
        return 31 * hash + this.authType.hashCode();
    }

    public String toString() {
        return "HandshakeV10Request{header=" + this.header + ", envelopeId=" + this.envelopeId + ", salt=REDACTED, serverCapability=" + this.serverCapability + ", serverStatuses=" + this.serverStatuses + ", authType='" + this.authType + "'}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HandshakeV10Request decode(int envelopeId, ByteBuf buf, HandshakeHeader header) {
        Builder builder = new Builder(envelopeId, header);
        ByteBuf salt = buf.alloc().buffer();
        try {
            salt.writeBytes(buf, buf.readerIndex(), 8);
            buf.skipBytes(9);
            long loCapabilities = buf.readUnsignedShortLE();
            buf.skipBytes(1);
            builder.serverStatuses(buf.readShortLE());
            long miCapabilities = (long)buf.readUnsignedShortLE() << 16;
            Capability capability = Capability.of(loCapabilities | miCapabilities);
            short saltSize = buf.readUnsignedByte();
            if (capability.isMariaDb()) {
                buf.skipBytes(6);
                builder.serverCapability(capability.extendMariaDb(buf.readUnsignedIntLE()));
            } else {
                buf.skipBytes(10);
                builder.serverCapability(capability);
            }
            if (capability.isSaltSecured()) {
                int saltSecondPartSize = Math.max(12, saltSize - 8 - 1);
                salt.writeBytes(buf, buf.readerIndex(), saltSecondPartSize);
                buf.skipBytes(saltSecondPartSize + 1);
            }
            builder.salt(ByteBufUtil.getBytes((ByteBuf)salt));
            if (capability.isPluginAuthAllowed()) {
                int length = buf.bytesBefore((byte)0);
                if (length < 0) {
                    builder.authType(buf.toString(StandardCharsets.US_ASCII));
                } else {
                    builder.authType(length == 0 ? "" : buf.toString(buf.readerIndex(), length, StandardCharsets.US_ASCII));
                }
            } else {
                builder.authType("");
            }
            HandshakeV10Request handshakeV10Request = builder.build();
            return handshakeV10Request;
        }
        finally {
            salt.release();
        }
    }

    private static final class Builder {
        private final int envelopeId;
        private final HandshakeHeader header;
        private String authType;
        private byte[] salt;
        private Capability serverCapability;
        private short serverStatuses;

        private Builder(int envelopeId, HandshakeHeader header) {
            this.envelopeId = envelopeId;
            this.header = header;
        }

        HandshakeV10Request build() {
            return new HandshakeV10Request(this.header, this.envelopeId, this.salt, this.serverCapability, this.serverStatuses, this.authType);
        }

        void authType(String authType) {
            this.authType = authType;
        }

        void salt(byte[] salt) {
            this.salt = salt;
        }

        void serverCapability(Capability serverCapability) {
            this.serverCapability = serverCapability;
        }

        void serverStatuses(short serverStatuses) {
            this.serverStatuses = serverStatuses;
        }
    }
}

