/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql;

import io.asyncer.r2dbc.mysql.ConnectionContext;
import io.asyncer.r2dbc.mysql.MySqlBatchingBatch;
import io.asyncer.r2dbc.mysql.MySqlClientConnectionMetadata;
import io.asyncer.r2dbc.mysql.MySqlSyntheticBatch;
import io.asyncer.r2dbc.mysql.PingStatement;
import io.asyncer.r2dbc.mysql.PrepareParameterizedStatement;
import io.asyncer.r2dbc.mysql.PrepareSimpleStatement;
import io.asyncer.r2dbc.mysql.Query;
import io.asyncer.r2dbc.mysql.QueryFlow;
import io.asyncer.r2dbc.mysql.TextParameterizedStatement;
import io.asyncer.r2dbc.mysql.TextSimpleStatement;
import io.asyncer.r2dbc.mysql.api.MySqlBatch;
import io.asyncer.r2dbc.mysql.api.MySqlConnection;
import io.asyncer.r2dbc.mysql.api.MySqlConnectionMetadata;
import io.asyncer.r2dbc.mysql.api.MySqlStatement;
import io.asyncer.r2dbc.mysql.api.MySqlTransactionDefinition;
import io.asyncer.r2dbc.mysql.cache.QueryCache;
import io.asyncer.r2dbc.mysql.client.Client;
import io.asyncer.r2dbc.mysql.codec.Codecs;
import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.internal.util.StringUtils;
import io.asyncer.r2dbc.mysql.message.server.CompleteMessage;
import io.asyncer.r2dbc.mysql.message.server.ErrorMessage;
import io.asyncer.r2dbc.mysql.message.server.ServerMessage;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.r2dbc.spi.IsolationLevel;
import io.r2dbc.spi.R2dbcNonTransientResourceException;
import io.r2dbc.spi.TransactionDefinition;
import io.r2dbc.spi.ValidationDepth;
import java.time.Duration;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import reactor.core.publisher.Mono;

final class MySqlSimpleConnection
implements MySqlConnection {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(MySqlSimpleConnection.class);
    private static final String PING_MARKER = "/* ping */";
    private static final Function<ServerMessage, Boolean> VALIDATE = message -> {
        if (message instanceof CompleteMessage && ((CompleteMessage)message).isDone()) {
            return true;
        }
        if (message instanceof ErrorMessage) {
            ErrorMessage msg = (ErrorMessage)message;
            logger.debug("Remote validate failed: [{}] [{}] {}", new Object[]{msg.getCode(), msg.getSqlState(), msg.getMessage()});
        } else {
            ReferenceCountUtil.safeRelease((Object)message);
        }
        return false;
    };
    private final Client client;
    private final Codecs codecs;
    private final MySqlConnectionMetadata metadata;
    private final QueryCache queryCache;
    @Nullable
    private final Predicate<String> prepare;
    private final boolean batchSupported;

    MySqlSimpleConnection(Client client, Codecs codecs, QueryCache queryCache, @Nullable Predicate<String> prepare) {
        ConnectionContext context = client.getContext();
        this.client = client;
        this.codecs = codecs;
        this.metadata = new MySqlClientConnectionMetadata(client);
        this.queryCache = queryCache;
        this.prepare = prepare;
        this.batchSupported = context.getCapability().isMultiStatementsAllowed();
        if (this.batchSupported) {
            logger.debug("Batch is supported by server");
        } else {
            logger.warn("The MySQL server does not support batch, fallback to executing one-by-one");
        }
    }

    @Override
    public Mono<Void> beginTransaction() {
        return this.beginTransaction(MySqlTransactionDefinition.empty());
    }

    @Override
    public Mono<Void> beginTransaction(TransactionDefinition definition) {
        return Mono.defer(() -> QueryFlow.beginTransaction(this.client, this.batchSupported, definition));
    }

    @Override
    public Mono<Void> close() {
        Mono<Void> closer = this.client.close();
        if (logger.isDebugEnabled()) {
            return closer.doOnSubscribe(s -> logger.debug("Connection closing")).doOnSuccess(ignored -> logger.debug("Connection close succeed"));
        }
        return closer;
    }

    @Override
    public Mono<Void> commitTransaction() {
        return Mono.defer(() -> QueryFlow.doneTransaction(this.client, true, this.batchSupported));
    }

    @Override
    public MySqlBatch createBatch() {
        return this.batchSupported ? new MySqlBatchingBatch(this.client, this.codecs) : new MySqlSyntheticBatch(this.client, this.codecs);
    }

    @Override
    public Mono<Void> createSavepoint(String name) {
        AssertUtils.requireNonEmpty(name, "Savepoint name must not be empty");
        return QueryFlow.createSavepoint(this.client, name, this.batchSupported);
    }

    @Override
    public MySqlStatement createStatement(String sql) {
        AssertUtils.requireNonNull(sql, "sql must not be null");
        if (sql.startsWith(PING_MARKER)) {
            return new PingStatement(this.client, this.codecs);
        }
        Query query = this.queryCache.get(sql);
        if (query.isSimple()) {
            if (this.prepare != null && this.prepare.test(sql)) {
                logger.debug("Create a simple statement provided by prepare query");
                return new PrepareSimpleStatement(this.client, this.codecs, sql);
            }
            logger.debug("Create a simple statement provided by text query");
            return new TextSimpleStatement(this.client, this.codecs, sql);
        }
        if (this.prepare == null) {
            logger.debug("Create a parameterized statement provided by text query");
            return new TextParameterizedStatement(this.client, this.codecs, query);
        }
        logger.debug("Create a parameterized statement provided by prepare query");
        return new PrepareParameterizedStatement(this.client, this.codecs, query);
    }

    @Override
    public Mono<Void> postAllocate() {
        return Mono.empty();
    }

    @Override
    public Mono<Void> preRelease() {
        return this.rollbackTransaction();
    }

    @Override
    public Mono<Void> releaseSavepoint(String name) {
        AssertUtils.requireNonEmpty(name, "Savepoint name must not be empty");
        return QueryFlow.executeVoid(this.client, "RELEASE SAVEPOINT " + StringUtils.quoteIdentifier(name));
    }

    @Override
    public Mono<Void> rollbackTransaction() {
        return Mono.defer(() -> QueryFlow.doneTransaction(this.client, false, this.batchSupported));
    }

    @Override
    public Mono<Void> rollbackTransactionToSavepoint(String name) {
        AssertUtils.requireNonEmpty(name, "Savepoint name must not be empty");
        return QueryFlow.executeVoid(this.client, "ROLLBACK TO SAVEPOINT " + StringUtils.quoteIdentifier(name));
    }

    @Override
    public MySqlConnectionMetadata getMetadata() {
        return this.metadata;
    }

    public IsolationLevel getTransactionIsolationLevel() {
        return this.client.getContext().getCurrentIsolationLevel();
    }

    @Override
    public Mono<Void> setTransactionIsolationLevel(IsolationLevel isolationLevel) {
        AssertUtils.requireNonNull(isolationLevel, "isolationLevel must not be null");
        return QueryFlow.executeVoid(this.client, "SET SESSION TRANSACTION ISOLATION LEVEL " + isolationLevel.asSql()).doOnSuccess(ignored -> {
            ConnectionContext context = this.client.getContext();
            context.setSessionIsolationLevel(isolationLevel);
            if (!context.isInTransaction()) {
                context.setCurrentIsolationLevel(isolationLevel);
            }
        });
    }

    @Override
    public Mono<Boolean> validate(ValidationDepth depth) {
        AssertUtils.requireNonNull(depth, "depth must not be null");
        if (depth == ValidationDepth.LOCAL) {
            return Mono.fromSupplier(this.client::isConnected);
        }
        return Mono.defer(() -> {
            if (!this.client.isConnected()) {
                return Mono.just((Object)false);
            }
            return QueryFlow.ping(this.client).map(VALIDATE).last().onErrorResume(e -> {
                logger.debug("Remote validate failed", e);
                return Mono.just((Object)false);
            });
        });
    }

    public boolean isAutoCommit() {
        return this.client.getContext().isAutoCommit();
    }

    @Override
    public Mono<Void> setAutoCommit(boolean autoCommit) {
        return Mono.defer(() -> QueryFlow.executeVoid(this.client, "SET autocommit=" + (autoCommit ? 1 : 0)));
    }

    @Override
    public Mono<Void> setLockWaitTimeout(Duration timeout) {
        AssertUtils.requireNonNull(timeout, "timeout must not be null");
        if (this.client.getContext().isLockWaitTimeoutSupported()) {
            return QueryFlow.executeVoid(this.client, StringUtils.lockWaitTimeoutStatement(timeout)).doOnSuccess(ignored -> this.client.getContext().setAllLockWaitTimeout(timeout));
        }
        logger.warn("Lock wait timeout is not supported by server, setLockWaitTimeout operation is ignored");
        return Mono.empty();
    }

    @Override
    public Mono<Void> setStatementTimeout(Duration timeout) {
        AssertUtils.requireNonNull(timeout, "timeout must not be null");
        ConnectionContext context = this.client.getContext();
        if (context.isStatementTimeoutSupported()) {
            String variable = StringUtils.statementTimeoutVariable(timeout, context.isMariaDb());
            return QueryFlow.setSessionVariable(this.client, variable);
        }
        return Mono.error((Throwable)new R2dbcNonTransientResourceException("Statement timeout is not supported by server version " + context.getServerVersion(), "HY000", -1));
    }

    @TestOnly
    ConnectionContext context() {
        return this.client.getContext();
    }
}

