/*
 * Decompiled with CFR 0.152.
 */
package io.asyncer.r2dbc.mysql.internal.util;

import io.asyncer.r2dbc.mysql.internal.util.AssertUtils;
import io.asyncer.r2dbc.mysql.internal.util.ReadCompletionHandler;
import io.asyncer.r2dbc.mysql.message.FieldValue;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

public final class NettyBufferUtils {
    public static Flux<ByteBuf> readFile(Path path, ByteBufAllocator allocator, int bufferSize) {
        AssertUtils.requireNonNull(path, "path must not be null");
        AssertUtils.requireNonNull(allocator, "allocator must not be null");
        AssertUtils.require(bufferSize > 0, "bufferSize must be positive");
        return Flux.create(sink -> {
            ReadCompletionHandler handler;
            try {
                AsynchronousFileChannel channel = AsynchronousFileChannel.open(path, StandardOpenOption.READ);
                handler = new ReadCompletionHandler(channel, allocator, bufferSize, (FluxSink<ByteBuf>)sink);
            }
            catch (Throwable e) {
                sink.error(e);
                return;
            }
            sink.onCancel(handler::cancel);
            sink.onRequest(handler::request);
        }).doOnDiscard(ByteBuf.class, ReferenceCountUtil::safeRelease);
    }

    public static ByteBuf composite(List<ByteBuf> parts) {
        int size = parts.size();
        switch (size) {
            case 0: {
                throw new IllegalStateException("No buffer available");
            }
            case 1: {
                try {
                    ByteBuf byteBuf = parts.get(0);
                    return byteBuf;
                }
                finally {
                    parts.clear();
                }
            }
        }
        CompositeByteBuf composite = null;
        try {
            composite = parts.get(0).alloc().compositeBuffer(size);
            CompositeByteBuf compositeByteBuf = composite.addComponents(true, parts);
            return compositeByteBuf;
        }
        catch (Throwable e) {
            if (composite == null) {
                NettyBufferUtils.releaseAll(parts);
            } else {
                composite.release();
            }
            throw e;
        }
        finally {
            parts.clear();
        }
    }

    public static void releaseAll(ReferenceCounted[] parts) {
        for (ReferenceCounted counted : parts) {
            if (counted == null) continue;
            ReferenceCountUtil.safeRelease((Object)counted);
        }
    }

    public static void releaseAll(FieldValue[] fields) {
        for (FieldValue field : fields) {
            if (field == null || field.isNull()) continue;
            ReferenceCountUtil.safeRelease((Object)field);
        }
    }

    public static void releaseAll(List<? extends ReferenceCounted> parts) {
        NettyBufferUtils.release0(parts, parts.size());
    }

    public static void releaseAll(FieldValue[] fields, int bound) {
        int size = Math.min(bound, fields.length);
        for (int i = 0; i < size; ++i) {
            FieldValue field = fields[i];
            if (field == null || field.isNull()) continue;
            ReferenceCountUtil.safeRelease((Object)field);
        }
    }

    public static void releaseAll(List<? extends ReferenceCounted> parts, int bound) {
        NettyBufferUtils.release0(parts, Math.min(bound, parts.size()));
    }

    private static void release0(List<? extends ReferenceCounted> parts, int size) {
        for (int i = 0; i < size; ++i) {
            ReferenceCounted counted = parts.get(i);
            if (counted == null) continue;
            ReferenceCountUtil.safeRelease((Object)counted);
        }
    }

    private NettyBufferUtils() {
    }
}

