/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.jdbc;

import io.awspring.cloud.autoconfigure.jdbc.AmazonRdsDatabaseProperties;
import io.awspring.cloud.context.config.xml.GlobalBeanDefinitionUtils;
import io.awspring.cloud.core.config.AmazonWebserviceClientConfigurationUtils;
import io.awspring.cloud.jdbc.config.annotation.AmazonRdsInstanceConfiguration;
import io.awspring.cloud.jdbc.config.annotation.RdsInstanceConfigurerBeanPostProcessor;
import io.awspring.cloud.jdbc.datasource.TomcatJdbcDataSourceFactory;
import io.awspring.cloud.jdbc.rds.AmazonRdsDataSourceFactoryBean;
import io.awspring.cloud.jdbc.rds.AmazonRdsReadReplicaAwareDataSourceFactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;

@Configuration(proxyBeanMethods=false)
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
@Import(value={Registrar.class})
@ConditionalOnClass(name={"com.amazonaws.services.rds.AmazonRDSClient"})
@ConditionalOnMissingBean(value={AmazonRdsInstanceConfiguration.class})
@ConditionalOnProperty(name={"cloud.aws.rds.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={AmazonRdsDatabaseProperties.class})
public class AmazonRdsDatabaseAutoConfiguration {
    @Bean
    public static RdsInstanceConfigurerBeanPostProcessor rdsInstanceConfigurerBeanPostProcessor() {
        return new RdsInstanceConfigurerBeanPostProcessor();
    }

    public static class Registrar
    implements ImportBeanDefinitionRegistrar,
    EnvironmentAware {
        private ConfigurableEnvironment environment;

        public void registerBeanDefinitions(AnnotationMetadata importingClassMetadata, BeanDefinitionRegistry registry) {
            AmazonRdsDatabaseProperties properties = this.rdsDatabaseProperties();
            String endpoint = properties.getEndpoint() != null ? properties.getEndpoint().toString() : null;
            String amazonRdsClientBeanName = AmazonWebserviceClientConfigurationUtils.registerAmazonWebserviceClient((Object)this, (BeanDefinitionRegistry)registry, (String)"com.amazonaws.services.rds.AmazonRDSClient", null, (String)properties.getRegion(), (String)endpoint, (String)"rdsClientConfiguration").getBeanName();
            properties.getInstances().stream().filter(AmazonRdsDatabaseProperties.RdsInstance::hasRequiredPropertiesSet).forEach(instance -> Registrar.registerDatasource(registry, amazonRdsClientBeanName, instance));
        }

        private AmazonRdsDatabaseProperties rdsDatabaseProperties() {
            return (AmazonRdsDatabaseProperties)((Object)Binder.get((Environment)this.environment).bindOrCreate("cloud.aws.rds", AmazonRdsDatabaseProperties.class));
        }

        private static void registerDatasource(BeanDefinitionRegistry registry, String amazonRdsClientBeanName, AmazonRdsDatabaseProperties.RdsInstance instance) {
            BeanDefinitionBuilder datasourceBuilder = BeanDefinitionBuilder.genericBeanDefinition(instance.isReadReplicaSupport() ? AmazonRdsReadReplicaAwareDataSourceFactoryBean.class : AmazonRdsDataSourceFactoryBean.class);
            datasourceBuilder.addConstructorArgReference(amazonRdsClientBeanName);
            Assert.hasText((String)instance.getDbInstanceIdentifier(), (String)"The dbInstanceIdentifier can't be empty.");
            datasourceBuilder.addConstructorArgValue((Object)instance.getDbInstanceIdentifier());
            Assert.hasText((String)instance.getPassword(), (String)"The password can't be empty.");
            datasourceBuilder.addConstructorArgValue((Object)instance.getPassword());
            datasourceBuilder.addPropertyValue("username", (Object)instance.getUsername());
            datasourceBuilder.addPropertyValue("databaseName", (Object)instance.getDatabaseName());
            String resourceResolverBeanName = GlobalBeanDefinitionUtils.retrieveResourceIdResolverBeanName((BeanDefinitionRegistry)registry);
            datasourceBuilder.addPropertyReference("resourceIdResolver", resourceResolverBeanName);
            datasourceBuilder.addPropertyValue("dataSourceFactory", (Object)BeanDefinitionBuilder.rootBeanDefinition(TomcatJdbcDataSourceFactory.class).getBeanDefinition());
            registry.registerBeanDefinition(instance.getDbInstanceIdentifier(), (BeanDefinition)datasourceBuilder.getBeanDefinition());
        }

        public void setEnvironment(Environment environment) {
            Assert.isInstanceOf(ConfigurableEnvironment.class, (Object)environment, (String)"Amazon RDS auto configuration requires a configurable environment");
            this.environment = (ConfigurableEnvironment)environment;
        }
    }
}

