/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.autoconfigure.config.secretsmanager;

import io.awspring.cloud.autoconfigure.config.reload.ConfigurationChangeDetector;
import io.awspring.cloud.autoconfigure.config.reload.ConfigurationUpdateStrategy;
import io.awspring.cloud.autoconfigure.config.reload.PollingAwsPropertySourceChangeDetector;
import io.awspring.cloud.autoconfigure.config.secretsmanager.SecretsManagerProperties;
import io.awspring.cloud.secretsmanager.SecretsManagerPropertySource;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.endpoint.EndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.info.InfoEndpointAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.cloud.autoconfigure.RefreshEndpointAutoConfiguration;
import org.springframework.cloud.commons.util.TaskSchedulerWrapper;
import org.springframework.cloud.context.refresh.ContextRefresher;
import org.springframework.cloud.context.restart.RestartEndpoint;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

@AutoConfiguration
@EnableConfigurationProperties(value={SecretsManagerProperties.class})
@ConditionalOnClass(value={EndpointAutoConfiguration.class, RestartEndpoint.class, ContextRefresher.class})
@AutoConfigureAfter(value={InfoEndpointAutoConfiguration.class, RefreshEndpointAutoConfiguration.class, RefreshAutoConfiguration.class})
@ConditionalOnProperty(value={"spring.cloud.aws.secretsmanager.reload.strategy"})
@ConditionalOnBean(value={ContextRefresher.class})
public class SecretsManagerReloadAutoConfiguration {
    @Bean(value={"secretsManagerTaskScheduler"})
    @ConditionalOnMissingBean(name={"secretsManagerTaskScheduler"})
    public TaskSchedulerWrapper<TaskScheduler> secretsManagerTaskScheduler() {
        ThreadPoolTaskScheduler threadPoolTaskScheduler = new ThreadPoolTaskScheduler();
        threadPoolTaskScheduler.setThreadNamePrefix("spring-cloud-aws-secretsmanager-ThreadPoolTaskScheduler-");
        threadPoolTaskScheduler.setDaemon(true);
        return new TaskSchedulerWrapper((TaskScheduler)threadPoolTaskScheduler);
    }

    @Bean(value={"secretsManagerConfigurationUpdateStrategy"})
    @ConditionalOnMissingBean(name={"secretsManagerConfigurationUpdateStrategy"})
    public ConfigurationUpdateStrategy secretsManagerConfigurationUpdateStrategy(SecretsManagerProperties properties, Optional<RestartEndpoint> restarter, ContextRefresher refresher) {
        return ConfigurationUpdateStrategy.create(properties.getReload(), refresher, restarter);
    }

    @Bean
    @ConditionalOnBean(value={ConfigurationUpdateStrategy.class})
    public ConfigurationChangeDetector<SecretsManagerPropertySource> secretsManagerPollingAwsPropertySourceChangeDetector(SecretsManagerProperties properties, @Qualifier(value="secretsManagerConfigurationUpdateStrategy") ConfigurationUpdateStrategy strategy, @Qualifier(value="secretsManagerTaskScheduler") TaskSchedulerWrapper<TaskScheduler> taskScheduler, ConfigurableEnvironment environment) {
        return new PollingAwsPropertySourceChangeDetector<SecretsManagerPropertySource>(properties.getReload(), SecretsManagerPropertySource.class, strategy, taskScheduler.getTaskScheduler(), environment);
    }
}

