/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.messaging.core;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.sqs.AmazonSQSAsync;
import com.amazonaws.services.sqs.model.DeleteMessageRequest;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.MessageAttributeValue;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import io.awspring.cloud.messaging.core.QueueMessageUtils;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.messaging.MessageDeliveryException;
import org.springframework.messaging.PollableChannel;
import org.springframework.messaging.support.AbstractMessageChannel;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.util.NumberUtils;

public class QueueMessageChannel
extends AbstractMessageChannel
implements PollableChannel {
    static final String ATTRIBUTE_NAMES = "All";
    private static final String MESSAGE_ATTRIBUTE_NAMES = "All";
    private final AmazonSQSAsync amazonSqs;
    private final String queueUrl;

    public QueueMessageChannel(AmazonSQSAsync amazonSqs, String queueUrl) {
        this.amazonSqs = amazonSqs;
        this.queueUrl = queueUrl;
    }

    private static boolean isSkipHeader(String headerName) {
        return "delay".equals(headerName) || "message-deduplication-id".equals(headerName) || "message-group-id".equals(headerName);
    }

    protected boolean sendInternal(org.springframework.messaging.Message<?> message, long timeout) {
        try {
            this.sendMessageAndWaitForResult(this.prepareSendMessageRequest(message), timeout);
        }
        catch (AmazonServiceException e) {
            throw new MessageDeliveryException(message, e.getMessage(), (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new MessageDeliveryException(message, e.getMessage(), e.getCause());
        }
        catch (TimeoutException e) {
            return false;
        }
        return true;
    }

    private SendMessageRequest prepareSendMessageRequest(org.springframework.messaging.Message<?> message) {
        Map<String, MessageAttributeValue> messageAttributes;
        SendMessageRequest sendMessageRequest = new SendMessageRequest(this.queueUrl, String.valueOf(message.getPayload()));
        if (message.getHeaders().containsKey((Object)"message-group-id")) {
            sendMessageRequest.setMessageGroupId((String)message.getHeaders().get((Object)"message-group-id", String.class));
        }
        if (message.getHeaders().containsKey((Object)"message-deduplication-id")) {
            sendMessageRequest.setMessageDeduplicationId((String)message.getHeaders().get((Object)"message-deduplication-id", String.class));
        }
        if (message.getHeaders().containsKey((Object)"delay")) {
            sendMessageRequest.setDelaySeconds((Integer)message.getHeaders().get((Object)"delay", Integer.class));
        }
        if (!(messageAttributes = this.getMessageAttributes(message)).isEmpty()) {
            sendMessageRequest.withMessageAttributes(messageAttributes);
        }
        return sendMessageRequest;
    }

    private void sendMessageAndWaitForResult(SendMessageRequest sendMessageRequest, long timeout) throws ExecutionException, TimeoutException {
        if (timeout > 0L) {
            Future sendMessageFuture = this.amazonSqs.sendMessageAsync(sendMessageRequest);
            try {
                sendMessageFuture.get(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } else {
            this.amazonSqs.sendMessage(sendMessageRequest);
        }
    }

    private Map<String, MessageAttributeValue> getMessageAttributes(org.springframework.messaging.Message<?> message) {
        HashMap<String, MessageAttributeValue> messageAttributes = new HashMap<String, MessageAttributeValue>();
        for (Map.Entry messageHeader : message.getHeaders().entrySet()) {
            String messageHeaderName = (String)messageHeader.getKey();
            Object messageHeaderValue = messageHeader.getValue();
            if (QueueMessageChannel.isSkipHeader(messageHeaderName)) continue;
            if ("contentType".equals(messageHeaderName) && messageHeaderValue != null) {
                messageAttributes.put(messageHeaderName, this.getContentTypeMessageAttribute(messageHeaderValue));
                continue;
            }
            if ("id".equals(messageHeaderName) && messageHeaderValue != null) {
                messageAttributes.put(messageHeaderName, this.getStringMessageAttribute(messageHeaderValue.toString()));
                continue;
            }
            if (messageHeaderValue instanceof String) {
                messageAttributes.put(messageHeaderName, this.getStringMessageAttribute((String)messageHeaderValue));
                continue;
            }
            if (messageHeaderValue instanceof Number) {
                messageAttributes.put(messageHeaderName, this.getNumberMessageAttribute(messageHeaderValue));
                continue;
            }
            if (messageHeaderValue instanceof ByteBuffer) {
                messageAttributes.put(messageHeaderName, this.getBinaryMessageAttribute((ByteBuffer)messageHeaderValue));
                continue;
            }
            this.logger.warn((Object)String.format("Message header with name '%s' and type '%s' cannot be sent as message attribute because it is not supported by SQS.", messageHeaderName, messageHeaderValue != null ? messageHeaderValue.getClass().getName() : ""));
        }
        return messageAttributes;
    }

    private MessageAttributeValue getBinaryMessageAttribute(ByteBuffer messageHeaderValue) {
        return new MessageAttributeValue().withDataType("Binary").withBinaryValue(messageHeaderValue);
    }

    private MessageAttributeValue getContentTypeMessageAttribute(Object messageHeaderValue) {
        if (messageHeaderValue instanceof MimeType) {
            return new MessageAttributeValue().withDataType("String").withStringValue(messageHeaderValue.toString());
        }
        if (messageHeaderValue instanceof String) {
            return new MessageAttributeValue().withDataType("String").withStringValue((String)messageHeaderValue);
        }
        return null;
    }

    private MessageAttributeValue getStringMessageAttribute(String messageHeaderValue) {
        return new MessageAttributeValue().withDataType("String").withStringValue(messageHeaderValue);
    }

    private MessageAttributeValue getNumberMessageAttribute(Object messageHeaderValue) {
        Assert.isTrue((boolean)NumberUtils.STANDARD_NUMBER_TYPES.contains(messageHeaderValue.getClass()), (String)"Only standard number types are accepted as message header.");
        return new MessageAttributeValue().withDataType("Number." + messageHeaderValue.getClass().getName()).withStringValue(messageHeaderValue.toString());
    }

    public org.springframework.messaging.Message<String> receive() {
        return this.receive(0L);
    }

    public org.springframework.messaging.Message<String> receive(long timeout) {
        ReceiveMessageResult receiveMessageResult = this.amazonSqs.receiveMessage(new ReceiveMessageRequest(this.queueUrl).withMaxNumberOfMessages(Integer.valueOf(1)).withWaitTimeSeconds(Integer.valueOf(Long.valueOf(timeout).intValue())).withAttributeNames(new String[]{"All"}).withMessageAttributeNames(new String[]{"All"}));
        if (receiveMessageResult.getMessages().isEmpty()) {
            return null;
        }
        Message amazonMessage = (Message)receiveMessageResult.getMessages().get(0);
        org.springframework.messaging.Message<String> message = QueueMessageUtils.createMessage(amazonMessage);
        this.amazonSqs.deleteMessage(new DeleteMessageRequest(this.queueUrl, amazonMessage.getReceiptHandle()));
        return message;
    }
}

