/*
 * Decompiled with CFR 0.152.
 */
package io.basc.framework.log4j2;

import io.basc.framework.io.Resource;
import io.basc.framework.io.ResourceUtils;
import java.net.URI;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.Configurator;

public class Log4j2Utils {
    private static Logger logger = LogManager.getLogger(Log4j2Utils.class);
    private static final String DEFAULT_CONFIG_LOCATION = "io/basc/framework/log4j2/configuration.xml";
    private static final String CONFIG_LOCATION = "log4j2.xml";

    public static void reconfigure() {
        Resource resource = ResourceUtils.getSystemResource((String)CONFIG_LOCATION);
        if (resource != null && resource.exists()) {
            Log4j2Utils.reconfigure(resource);
            return;
        }
        resource = ResourceUtils.getSystemResource((String)DEFAULT_CONFIG_LOCATION);
        Log4j2Utils.reconfigure(resource);
    }

    public static void reconfigure(Resource resource) {
        if (resource == null || !resource.exists()) {
            return;
        }
        try {
            Configurator.reconfigure((URI)resource.getURI());
        }
        catch (Throwable e) {
            logger.error(resource.getDescription(), e);
        }
    }
}

