/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.util;

import java.util.Arrays;

public class StringEscapeHelper {
    private static final char NO_REPLACEMENT = '\uffff';
    private final char[] unescapeMap;
    private final char[] escapeMap;
    private final boolean unescapeUnicodeEscapes;

    public StringEscapeHelper(char ... replacementPairs) {
        this(false, replacementPairs);
    }

    public StringEscapeHelper(boolean unescapeUnicodeEscapes, char ... replacementPairs) {
        if (replacementPairs.length % 2 == 1) {
            throw new IllegalArgumentException("Replacements must be even pairs");
        }
        this.unescapeUnicodeEscapes = unescapeUnicodeEscapes;
        this.unescapeMap = StringEscapeHelper.createEscapeMap(replacementPairs, 0, 1);
        this.escapeMap = StringEscapeHelper.createEscapeMap(replacementPairs, 1, 0);
    }

    private static char[] createEscapeMap(char[] pairs, int keyOffset, int valueOffset) {
        int i;
        char max = '\u0000';
        for (i = 0; i < pairs.length; i += 2) {
            char c = pairs[i + keyOffset];
            if (c <= max) continue;
            max = c;
        }
        char[] replacementsMap = new char[max + 1];
        Arrays.fill(replacementsMap, '\uffff');
        for (i = 0; i < pairs.length; i += 2) {
            replacementsMap[pairs[i + keyOffset]] = pairs[i + valueOffset];
        }
        return replacementsMap;
    }

    public String unescape(String str) {
        int slashIndex = str.indexOf(92);
        if (slashIndex > -1) {
            int offset = 0;
            StringBuilder unescaped = new StringBuilder();
            while (slashIndex > -1) {
                char r;
                char c = str.charAt(slashIndex + 1);
                char c2 = r = c < this.unescapeMap.length ? this.unescapeMap[c] : (char)'\uffff';
                if (r != '\uffff') {
                    unescaped.append(str, offset, slashIndex);
                    unescaped.append(r);
                    offset = slashIndex + 2;
                } else if (this.unescapeUnicodeEscapes && c == 'u') {
                    String hexCode = str.substring(slashIndex + 2, slashIndex + 6);
                    String replacement = new String(Character.toChars(Integer.parseInt(hexCode, 16)));
                    unescaped.append(str, offset, slashIndex);
                    unescaped.append(replacement);
                    offset = slashIndex + 6;
                }
                slashIndex = str.indexOf(92, slashIndex + 2);
            }
            unescaped.append(str, offset, str.length());
            return unescaped.toString();
        }
        return str;
    }

    public String escape(String str) {
        StringBuilder escaped = new StringBuilder();
        int offset = 0;
        for (int i = 0; i < str.length(); ++i) {
            char r;
            char c = str.charAt(i);
            char c2 = r = c < this.escapeMap.length ? this.escapeMap[c] : (char)'\uffff';
            if (r == 65535) continue;
            escaped.append(str, offset, i);
            escaped.append('\\');
            escaped.append(r);
            offset = i + 1;
        }
        if (offset < str.length()) {
            escaped.append(str, offset, str.length());
        }
        return escaped.toString();
    }
}

