/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.auth;

import com.fasterxml.jackson.databind.JsonNode;
import io.camunda.operate.CamundaOperateClient;
import io.camunda.operate.auth.JwtAuthentication;
import io.camunda.operate.exception.OperateException;
import io.camunda.operate.util.JsonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class SelfManagedAuthentication
extends JwtAuthentication {
    private String clientId;
    private String clientSecret;
    private String keycloakUrl = "http://localhost:18080";
    private String keycloakRealm = "camunda-platform";
    private String keycloakTokenUrl = null;

    public SelfManagedAuthentication() {
    }

    public SelfManagedAuthentication(String clientId, String clientSecret) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
    }

    public SelfManagedAuthentication clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public SelfManagedAuthentication clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public SelfManagedAuthentication keycloakUrl(String url) {
        this.keycloakUrl = url;
        return this;
    }

    public SelfManagedAuthentication keycloakRealm(String keycloakRealm) {
        this.keycloakRealm = keycloakRealm;
        return this;
    }

    public SelfManagedAuthentication keycloakTokenUrl(String keycloakTokenUrl) {
        this.keycloakTokenUrl = keycloakTokenUrl;
        return this;
    }

    private String encode(String value) throws UnsupportedEncodingException {
        return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
    }

    private String getConnectionString() throws UnsupportedEncodingException {
        return "grant_type=client_credentials&client_id=" + this.encode(this.clientId) + "&client_secret=" + this.encode(this.clientSecret);
    }

    @Override
    public void authenticate(CamundaOperateClient client) throws OperateException {
        block17: {
            try {
                String tokenUrl = this.keycloakTokenUrl;
                if (tokenUrl == null || tokenUrl.equals("")) {
                    tokenUrl = this.keycloakUrl + "/auth/realms/" + this.keycloakRealm + "/protocol/openid-connect/token";
                }
                URL url = new URL(tokenUrl);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setUseCaches(false);
                conn.setConnectTimeout(5000);
                conn.setDoOutput(true);
                conn.setDoInput(true);
                conn.setRequestMethod("POST");
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                String data = this.getConnectionString();
                conn.getOutputStream().write(data.getBytes(StandardCharsets.UTF_8));
                conn.connect();
                if (conn.getResponseCode() == 200) {
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "utf-8"));){
                        StringBuilder response = new StringBuilder();
                        String responseLine = null;
                        while ((responseLine = br.readLine()) != null) {
                            response.append(responseLine.trim());
                        }
                        JsonNode responseBody = JsonUtils.toJsonNode(response.toString());
                        String token = responseBody.get("access_token").asText();
                        this.setToken(client, token);
                        break block17;
                    }
                }
                throw new OperateException("Error " + conn.getResponseCode() + " obtaining access token : " + conn.getResponseMessage());
            }
            catch (IOException e) {
                throw new OperateException(e);
            }
        }
    }
}

