/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.beta;

import com.fasterxml.jackson.databind.JsonNode;
import io.camunda.operate.CamundaOperateClient;
import io.camunda.operate.beta.model.AuditTrail;
import io.camunda.operate.beta.model.AuditTrailStep;
import io.camunda.operate.beta.model.FlowNodeInstanceQueryList;
import io.camunda.operate.dto.ProcessInstance;
import io.camunda.operate.exception.OperateException;
import io.camunda.operate.util.JsonUtils;
import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class CamundaOperateBetaClient
extends CamundaOperateClient {
    public JsonNode getFlowNodeStates(Long processInstanceId) throws OperateException {
        String url = this.getOperateUrl() + "/api/process-instances/" + processInstanceId + "/flow-node-states";
        HttpGet httpPost = new HttpGet(url);
        httpPost.addHeader(this.getAuthHeader());
        httpPost.addHeader("content-type", (Object)"application/json");
        try {
            return JsonUtils.toJsonNode(this.executeQuery((ClassicHttpRequest)httpPost));
        }
        catch (IOException e) {
            throw new OperateException("BETA : Error getting  FlowNodeInstances", e);
        }
    }

    public JsonNode getFlowNodeInstances(Long processInstanceId) throws OperateException {
        String url = this.getOperateUrl() + "/api/flow-node-instances";
        FlowNodeInstanceQueryList query = new FlowNodeInstanceQueryList.Builder().processInstanceId(processInstanceId).build();
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader(this.getAuthHeader());
        httpPost.addHeader("content-type", (Object)"application/json");
        try {
            String data = JsonUtils.toJson(query);
            httpPost.setEntity((HttpEntity)new StringEntity(data));
            return JsonUtils.toJsonNode(this.executeQuery((ClassicHttpRequest)httpPost));
        }
        catch (IOException e) {
            throw new OperateException("BETA : Error getting  FlowNodeInstances", e);
        }
    }

    public AuditTrail getAuditTrail(Long processInstanceId) throws OperateException {
        AuditTrail auditTrail = new AuditTrail();
        ProcessInstance processInstance = this.getProcessInstance(processInstanceId);
        auditTrail.setProcessName(processInstance.getBpmnProcessId());
        auditTrail.setProcessVersion(processInstance.getProcessVersion());
        auditTrail.setSteps(new ArrayList<AuditTrailStep>());
        Long processDefinitionKey = processInstance.getProcessDefinitionKey();
        BpmnModelInstance bpmModel = this.getProcessDefinitionModel(processDefinitionKey);
        JsonNode flowNodeInstances = this.getFlowNodeInstances(processInstanceId);
        JsonNode flowNodesChildren = flowNodeInstances.get("" + processInstanceId).get("children");
        if (flowNodesChildren.isArray()) {
            for (JsonNode jsonNode : flowNodesChildren) {
                String type = jsonNode.get("type").asText();
                if (type.endsWith("GATEWAY")) continue;
                AuditTrailStep auditTrailStep = new AuditTrailStep();
                String stepId = jsonNode.get("flowNodeId").asText();
                auditTrailStep.setName(bpmModel.getModelElementById(stepId).getAttributeValue("name"));
                auditTrailStep.setType(type);
                String startDate = jsonNode.get("startDate").asText();
                String endDate = jsonNode.get("endDate").asText();
                if (!startDate.equals("null")) {
                    auditTrailStep.setStartDate(startDate.substring(0, 19));
                }
                if (!endDate.equals("null")) {
                    auditTrailStep.setEndDate(endDate.substring(0, 19));
                } else {
                    auditTrailStep.setEndDate("pending");
                }
                auditTrail.getSteps().add(auditTrailStep);
            }
        }
        return auditTrail;
    }
}

