/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist;

import com.apollographql.apollo3.ApolloCall;
import com.apollographql.apollo3.ApolloClient;
import com.apollographql.apollo3.api.ApolloResponse;
import com.apollographql.apollo3.api.Mutation;
import com.apollographql.apollo3.api.Operation;
import com.apollographql.apollo3.api.Optional;
import com.apollographql.apollo3.api.Query;
import com.apollographql.apollo3.exception.ApolloHttpException;
import com.apollographql.apollo3.rx3.Rx3Apollo;
import io.camunda.tasklist.auth.AuthInterface;
import io.camunda.tasklist.dto.DateFilter;
import io.camunda.tasklist.dto.Form;
import io.camunda.tasklist.dto.Pagination;
import io.camunda.tasklist.dto.SearchType;
import io.camunda.tasklist.dto.Task;
import io.camunda.tasklist.dto.TaskList;
import io.camunda.tasklist.dto.TaskSearch;
import io.camunda.tasklist.dto.TaskState;
import io.camunda.tasklist.exception.TaskListException;
import io.camunda.tasklist.util.ApolloUtils;
import io.generated.tasklist.client.ClaimTaskMutation;
import io.generated.tasklist.client.CompleteTaskMutation;
import io.generated.tasklist.client.GetFormQuery;
import io.generated.tasklist.client.GetTaskQuery;
import io.generated.tasklist.client.GetTaskWithVariablesQuery;
import io.generated.tasklist.client.GetTasksQuery;
import io.generated.tasklist.client.GetTasksWithVariableQuery;
import io.generated.tasklist.client.UnclaimTaskMutation;
import io.generated.tasklist.client.type.TaskOrderBy;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CamundaTaskListClient {
    private AuthInterface authentication;
    private ApolloClient apolloClient;
    private String taskListUrl;
    private boolean defaultShouldReturnVariables;
    private int tokenExpiration;

    public Task unclaim(String taskId) throws TaskListException {
        ApolloCall unclaimCall = this.apolloClient.mutation((Mutation)new UnclaimTaskMutation(taskId));
        ApolloResponse response = this.execute(unclaimCall);
        return ApolloUtils.toTask(((UnclaimTaskMutation.Data)response.data).unclaimTask);
    }

    public Task claim(String taskId, String assignee) throws TaskListException {
        return this.claim(taskId, assignee, false);
    }

    public Task claim(String taskId, String assignee, Boolean allowOverrideAssignment) throws TaskListException {
        Optional<Boolean> optAllowOverrideAssignment = ApolloUtils.optional(allowOverrideAssignment);
        ApolloCall claimCall = this.apolloClient.mutation((Mutation)new ClaimTaskMutation(taskId, assignee, optAllowOverrideAssignment));
        ApolloResponse response = this.execute(claimCall);
        return ApolloUtils.toTask(((ClaimTaskMutation.Data)response.data).claimTask);
    }

    public Task completeTask(String taskId, Map<String, Object> variablesMap) throws TaskListException {
        ApolloCall completeTaskCall = this.apolloClient.mutation((Mutation)new CompleteTaskMutation(taskId, ApolloUtils.toVariableInput(variablesMap)));
        ApolloResponse response = this.execute(completeTaskCall);
        return ApolloUtils.toTask(((CompleteTaskMutation.Data)response.data).completeTask);
    }

    public TaskList getTasks(Boolean assigned, TaskState state, Integer pageSize) throws TaskListException {
        return this.getTasks(assigned, state, this.defaultShouldReturnVariables, new Pagination().setPageSize(pageSize));
    }

    public TaskList getTasks(Boolean assigned, TaskState state, Pagination pagination) throws TaskListException {
        return this.getTasks(assigned, state, this.defaultShouldReturnVariables, pagination);
    }

    public TaskList getTasks(Boolean assigned, TaskState state, boolean withVariables, Integer pageSize) throws TaskListException {
        return this.getTasks(null, assigned, null, state, withVariables, new Pagination().setPageSize(pageSize));
    }

    public TaskList getTasks(Boolean assigned, TaskState state, boolean withVariables, Pagination pagination) throws TaskListException {
        return this.getTasks(null, assigned, null, state, withVariables, pagination);
    }

    public TaskList getAssigneeTasks(String assigneeId, TaskState state, Integer pageSize) throws TaskListException {
        return this.getAssigneeTasks(assigneeId, state, this.defaultShouldReturnVariables, new Pagination().setPageSize(pageSize));
    }

    public TaskList getAssigneeTasks(String assigneeId, TaskState state, Pagination pagination) throws TaskListException {
        return this.getAssigneeTasks(assigneeId, state, this.defaultShouldReturnVariables, pagination);
    }

    public TaskList getAssigneeTasks(String assigneeId, TaskState state, boolean withVariables, Integer pageSize) throws TaskListException {
        return this.getTasks(null, true, assigneeId, state, withVariables, new Pagination().setPageSize(pageSize));
    }

    public TaskList getAssigneeTasks(String assigneeId, TaskState state, boolean withVariables, Pagination pagination) throws TaskListException {
        return this.getTasks(null, true, assigneeId, state, withVariables, pagination);
    }

    public TaskList getGroupTasks(String group, TaskState state, Integer pageSize) throws TaskListException {
        return this.getGroupTasks(group, state, this.defaultShouldReturnVariables, new Pagination().setPageSize(pageSize));
    }

    public TaskList getGroupTasks(String group, TaskState state, Pagination pagination) throws TaskListException {
        return this.getGroupTasks(group, state, this.defaultShouldReturnVariables, pagination);
    }

    public TaskList getGroupTasks(String group, TaskState state, boolean withVariables, Integer pageSize) throws TaskListException {
        return this.getTasks(group, null, null, state, withVariables, new Pagination().setPageSize(pageSize));
    }

    public TaskList getGroupTasks(String group, TaskState state, boolean withVariables, Pagination pagination) throws TaskListException {
        return this.getTasks(group, null, null, state, withVariables, pagination);
    }

    public Task getTask(String taskId) throws TaskListException {
        return this.getTask(taskId, this.defaultShouldReturnVariables);
    }

    public Task getTask(String taskId, boolean withVariables) throws TaskListException {
        if (!withVariables) {
            ApolloCall queryCall = this.apolloClient.query((Query)new GetTaskQuery(taskId));
            ApolloResponse response = this.execute(queryCall);
            return ApolloUtils.toTask(((GetTaskQuery.Data)response.data).task);
        }
        ApolloCall queryCall = this.apolloClient.query((Query)new GetTaskWithVariablesQuery(taskId));
        ApolloResponse response = this.execute(queryCall);
        return ApolloUtils.toTask(((GetTaskWithVariablesQuery.Data)response.data).task);
    }

    public Form getForm(String formId, String processDefinitionId) throws TaskListException {
        ApolloCall queryCall = this.apolloClient.query((Query)new GetFormQuery(formId, processDefinitionId));
        ApolloResponse response = this.execute(queryCall);
        return ApolloUtils.toForm(((GetFormQuery.Data)response.data).form);
    }

    public TaskList before(TaskList taskList) throws TaskListException {
        return this.paginate(taskList, SearchType.BEFORE);
    }

    public TaskList after(TaskList taskList) throws TaskListException {
        return this.paginate(taskList, SearchType.AFTER);
    }

    public TaskList afterOrEqual(TaskList taskList) throws TaskListException {
        return this.paginate(taskList, SearchType.AFTER_OR_EQUAL);
    }

    private TaskList paginate(TaskList taskList, SearchType direction) throws TaskListException {
        if (taskList.getSearch().getPagination() == null || taskList.getSearch().getPagination().getPageSize() == null) {
            throw new TaskListException("Before/After/AfterOrEquals search are only possible if a pageSize is set");
        }
        if (taskList.getItems() == null || taskList.getItems().isEmpty()) {
            throw new TaskListException("Before/After/AfterOrEquals search are only possible if some items are present");
        }
        TaskSearch newSearch = new TaskSearch().setAssigned(taskList.getSearch().getAssigned()).setAssignee(taskList.getSearch().getAssignee()).setGroup(taskList.getSearch().getGroup()).setState(taskList.getSearch().getState()).setWithVariables(taskList.getSearch().isWithVariables()).setPagination(this.getSearchPagination(taskList, direction));
        return this.getTasks(newSearch);
    }

    private Pagination getSearchPagination(TaskList taskList, SearchType type) {
        switch (type) {
            case BEFORE: {
                return new Pagination.Builder().pageSize(taskList.getSearch().getPagination().getPageSize()).before(taskList.first().getSortValues()).build();
            }
            case AFTER: {
                return new Pagination.Builder().pageSize(taskList.getSearch().getPagination().getPageSize()).after(taskList.last().getSortValues()).build();
            }
        }
        return new Pagination.Builder().pageSize(taskList.getSearch().getPagination().getPageSize()).afterOrEqual(taskList.last().getSortValues()).build();
    }

    public TaskList getTasks(TaskSearch search) throws TaskListException {
        return this.getTasks(search.getCandidateUser(), search.getGroup(), search.getAssigned(), search.getAssignee(), search.getState(), search.getFollowUpDate(), search.getDueDate(), search.getProcessDefinitionId(), search.getProcessInstanceId(), search.getTaskDefinitionId(), search.isWithVariables(), search.getPagination());
    }

    public TaskList getTasks(String group, Boolean assigned, String assigneeId, TaskState state, boolean withVariables, Pagination pagination) throws TaskListException {
        return this.getTasks(null, group, assigned, assigneeId, state, null, null, null, null, null, withVariables, pagination);
    }

    public TaskList getTasks(String candidateUser, String group, Boolean assigned, String assigneeId, TaskState state, DateFilter followUpDate, DateFilter dueDate, String processDefinitionId, String processInstanceId, String taskDefinitionId, boolean withVariables, Pagination pagination) throws TaskListException {
        Optional<String> optCandidateUser = ApolloUtils.optional(candidateUser);
        Optional<String> optGroup = ApolloUtils.optional(group);
        Optional<String> optAssignee = ApolloUtils.optional(assigneeId);
        Optional<Boolean> optAssigned = ApolloUtils.optional(assigned);
        Optional<io.generated.tasklist.client.type.DateFilter> optFollowUpDate = ApolloUtils.optional(followUpDate);
        Optional<io.generated.tasklist.client.type.DateFilter> optDueDate = ApolloUtils.optional(dueDate);
        Optional<String> optProcessDefinitionId = ApolloUtils.optional(processDefinitionId);
        Optional<String> optProcessInstanceId = ApolloUtils.optional(processInstanceId);
        Optional<String> optTaskDefinitionId = ApolloUtils.optional(taskDefinitionId);
        Optional<Integer> optPageSize = null;
        Optional<List<String>> optSearchBefore = null;
        Optional<List<String>> optSearchAfter = null;
        Optional<List<String>> optSearchAfterOrEqual = null;
        Optional<List<TaskOrderBy>> optSort = null;
        if (pagination != null) {
            optSort = ApolloUtils.optionalSort(pagination.getSort());
            optPageSize = ApolloUtils.optional(pagination.getPageSize());
            if (pagination.getSearch() != null && !pagination.getSearch().isEmpty() && pagination.getSearchType() != null) {
                switch (pagination.getSearchType()) {
                    case BEFORE: {
                        optSearchBefore = ApolloUtils.optional(pagination.getSearch());
                        break;
                    }
                    case AFTER: {
                        optSearchAfter = ApolloUtils.optional(pagination.getSearch());
                        break;
                    }
                    case AFTER_OR_EQUAL: {
                        optSearchAfterOrEqual = ApolloUtils.optional(pagination.getSearch());
                    }
                }
            }
        }
        Optional<io.generated.tasklist.client.type.TaskState> optState = ApolloUtils.optional(state);
        if (!withVariables) {
            ApolloCall queryCall = this.apolloClient.query((Query)new GetTasksQuery(optCandidateUser, optGroup, optAssignee, optAssigned, optState, optProcessDefinitionId, optProcessInstanceId, optTaskDefinitionId, optFollowUpDate, optDueDate, optPageSize, optSearchAfter, optSearchBefore, optSearchAfterOrEqual, optSort));
            ApolloResponse response = this.execute(queryCall);
            return new TaskList().setItems(ApolloUtils.toTasks(((GetTasksQuery.Data)response.data).tasks)).setSearch(new TaskSearch().setCandidateUser(candidateUser).setAssigned(assigned).setAssignee(assigneeId).setGroup(group).setProcessDefinitionId(processDefinitionId).setProcessInstanceId(processInstanceId).setFollowUpDate(followUpDate).setDueDate(dueDate).setTaskDefinitionId(taskDefinitionId).setState(state).setWithVariables(withVariables).setPagination(pagination));
        }
        ApolloCall queryCall = this.apolloClient.query((Query)new GetTasksWithVariableQuery(optCandidateUser, optGroup, optAssignee, optAssigned, optState, optProcessDefinitionId, optProcessInstanceId, optTaskDefinitionId, optFollowUpDate, optDueDate, optPageSize, optSearchAfter, optSearchBefore, optSearchAfterOrEqual, optSort));
        ApolloResponse response = this.execute(queryCall);
        return new TaskList().setItems(ApolloUtils.toTasks(((GetTasksWithVariableQuery.Data)response.data).tasks)).setSearch(new TaskSearch().setCandidateUser(candidateUser).setAssigned(assigned).setAssignee(assigneeId).setGroup(group).setProcessDefinitionId(processDefinitionId).setProcessInstanceId(processInstanceId).setFollowUpDate(followUpDate).setDueDate(dueDate).setTaskDefinitionId(taskDefinitionId).setState(state).setWithVariables(withVariables).setPagination(pagination));
    }

    private <T extends Operation.Data> ApolloResponse<T> execute(ApolloCall<T> call) throws TaskListException {
        this.reconnectEventually();
        ApolloResponse result = null;
        try {
            result = (ApolloResponse)Rx3Apollo.single(call).blockingGet();
        }
        catch (ApolloHttpException e2) {
            if (e2.getStatusCode() == 401) {
                this.authentication.authenticate(this);
                try {
                    result = (ApolloResponse)Rx3Apollo.single(call).blockingGet();
                }
                catch (Exception e22) {
                    throw new TaskListException(e22);
                }
            }
            throw new TaskListException((Exception)((Object)e2));
        }
        if (result == null) {
            return null;
        }
        if (result.hasErrors()) {
            String errorString = result.errors.stream().map(e -> e.toString()).collect(Collectors.joining(","));
            throw new TaskListException(errorString);
        }
        return result;
    }

    public ApolloClient getApolloClient() {
        return this.apolloClient;
    }

    public String getTaskListUrl() {
        return this.taskListUrl;
    }

    public void setTokenExpiration(int tokenExpiration) {
        this.tokenExpiration = tokenExpiration;
    }

    private void reconnectEventually() throws TaskListException {
        if (this.tokenExpiration > 0 && (long)this.tokenExpiration < System.currentTimeMillis() / 1000L - 3L) {
            this.authentication.authenticate(this);
        }
    }

    public static class Builder {
        private AuthInterface authentication;
        private String taskListUrl;
        private boolean defaultShouldReturnVariables = false;

        public Builder authentication(AuthInterface authentication) {
            this.authentication = authentication;
            return this;
        }

        public Builder taskListUrl(String taskListUrl) {
            this.taskListUrl = taskListUrl;
            return this;
        }

        public Builder shouldReturnVariables() {
            this.defaultShouldReturnVariables = true;
            return this;
        }

        public CamundaTaskListClient build() throws TaskListException {
            CamundaTaskListClient client = new CamundaTaskListClient();
            client.authentication = this.authentication;
            client.taskListUrl = this.taskListUrl;
            client.defaultShouldReturnVariables = this.defaultShouldReturnVariables;
            client.apolloClient = new ApolloClient.Builder().httpServerUrl(this.formatUrl(this.taskListUrl)).addHttpHeader("", "").build();
            this.authentication.authenticate(client);
            return client;
        }

        private String formatUrl(String url) {
            if (url.endsWith("/graphql")) {
                return url;
            }
            if (url.endsWith("/")) {
                return url + "graphql";
            }
            return url + "/graphql";
        }
    }
}

