/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist;

import io.camunda.common.auth.Authentication;
import io.camunda.common.auth.JwtConfig;
import io.camunda.common.auth.JwtCredential;
import io.camunda.common.auth.Product;
import io.camunda.common.auth.SaaSAuthentication;
import io.camunda.common.auth.SaaSAuthenticationBuilder;
import io.camunda.common.auth.SelfManagedAuthentication;
import io.camunda.common.auth.SelfManagedAuthenticationBuilder;
import io.camunda.common.auth.identity.IdentityConfig;
import io.camunda.common.auth.identity.IdentityContainer;
import io.camunda.common.json.JsonMapper;
import io.camunda.common.json.SdkObjectMapper;
import io.camunda.identity.sdk.Identity;
import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.tasklist.CamundaTaskListClient;
import io.camunda.tasklist.CamundaTaskListClientProperties;
import io.camunda.tasklist.exception.TaskListException;
import io.camunda.zeebe.client.ZeebeClient;
import java.time.Duration;

public class CamundaTaskListClientBuilder {
    private CamundaTaskListClientProperties properties = new CamundaTaskListClientProperties();
    private ZeebeClient zeebeClient;

    public CamundaTaskListClientBuilder authentication(Authentication authentication) {
        this.properties.setAuthentication(authentication);
        return this;
    }

    public CamundaTaskListClientBuilder taskListUrl(String taskListUrl) {
        this.properties.setTaskListUrl(this.formatUrl(taskListUrl));
        return this;
    }

    public CamundaTaskListClientBuilder zeebeClient(ZeebeClient zeebeClient) {
        this.zeebeClient = zeebeClient;
        return this;
    }

    public CamundaTaskListClientBuilder shouldReturnVariables() {
        this.properties.setDefaultShouldReturnVariables(true);
        return this;
    }

    public CamundaTaskListClientBuilder shouldLoadTruncatedVariables() {
        this.properties.setDefaultShouldLoadTruncatedVariables(true);
        return this;
    }

    public CamundaTaskListClientBuilder alwaysReconnect() {
        this.properties.setAlwaysReconnect(true);
        return this;
    }

    public CamundaTaskListClientBuilder cookieExpiration(Duration cookieExpiration) {
        this.properties.setCookieExpiration(cookieExpiration);
        return this;
    }

    public CamundaTaskListClientBuilder useZeebeUserTasks() {
        this.properties.setUseZeebeUserTasks(true);
        return this;
    }

    public CamundaTaskListClient build() throws TaskListException {
        return new CamundaTaskListClient(this.properties, this.zeebeClient);
    }

    public CamundaTaskListClientBuilder selfManagedAuthentication(String clientId, String clientSecret, String keycloakUrl) {
        IdentityConfig identityConfig = new IdentityConfig();
        IdentityConfiguration identityConfiguration = new IdentityConfiguration(keycloakUrl, keycloakUrl, clientId, clientSecret, clientId);
        Identity identity = new Identity(identityConfiguration);
        identityConfig.addProduct(Product.TASKLIST, new IdentityContainer(identity, identityConfiguration));
        JwtConfig jwtConfig = new JwtConfig();
        jwtConfig.addProduct(Product.TASKLIST, new JwtCredential(clientId, clientSecret, clientId, keycloakUrl));
        this.properties.setAuthentication(((SelfManagedAuthenticationBuilder)SelfManagedAuthentication.builder().withJwtConfig(jwtConfig)).withIdentityConfig(identityConfig).build());
        return this;
    }

    public CamundaTaskListClientBuilder saaSAuthentication(String clientId, String clientSecret) {
        JwtConfig jwtConfig = new JwtConfig();
        jwtConfig.addProduct(Product.TASKLIST, new JwtCredential(clientId, clientSecret, "tasklist.camunda.io", "https://login.cloud.camunda.io/oauth/token"));
        this.properties.setAuthentication(((SaaSAuthenticationBuilder)SaaSAuthentication.builder().withJwtConfig(jwtConfig)).withJsonMapper((JsonMapper)new SdkObjectMapper()).build());
        return this;
    }

    private String formatUrl(String url) {
        if (url.endsWith("/")) {
            return url.substring(0, url.length() - 1);
        }
        return url;
    }
}

