/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound.importer;

import io.camunda.connector.runtime.inbound.importer.ProcessDefinitionSearch;
import io.camunda.connector.runtime.inbound.lifecycle.InboundConnectorManager;
import io.camunda.operate.model.ProcessDefinition;
import io.camunda.zeebe.spring.client.metrics.MetricsRecorder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;

public class ProcessDefinitionImporter {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessDefinitionImporter.class);
    private final InboundConnectorManager connectorManager;
    private final ProcessDefinitionSearch search;
    private final MetricsRecorder metricsRecorder;
    private final Set<Long> registeredProcessDefinitionKeys = new HashSet<Long>();
    private final Map<String, ProcessDefinition> versionByBpmnProcessId = new HashMap<String, ProcessDefinition>();
    private boolean ready = false;

    @Autowired
    public ProcessDefinitionImporter(InboundConnectorManager inboundManager, ProcessDefinitionSearch search, @Autowired(required=false) MetricsRecorder metricsRecorder) {
        this.connectorManager = inboundManager;
        this.search = search;
        this.metricsRecorder = metricsRecorder;
    }

    @Scheduled(fixedDelayString="${camunda.connector.polling.interval:5000}")
    public synchronized void scheduleImport() {
        try {
            List<ProcessDefinition> result = this.search.query();
            try {
                this.handleImportedDefinitions(result);
            }
            catch (Exception e) {
                LOG.error("Error during process definition import handling.", (Throwable)e);
            }
            this.ready = true;
        }
        catch (Exception e) {
            LOG.error("Failed to import process definitions", (Throwable)e);
            this.ready = false;
        }
    }

    public void handleImportedDefinitions(List<ProcessDefinition> definitions) {
        Set<ProcessDefinition> notYetRegistered = definitions.stream().filter(d -> !this.registeredProcessDefinitionKeys.contains(d.getKey())).collect(Collectors.toSet());
        HashSet oldProcessDefinitionKeys = new HashSet();
        Set<ProcessDefinition> upgraded = notYetRegistered.stream().filter(d -> this.versionByBpmnProcessId.containsKey(d.getBpmnProcessId()) && !d.getVersion().equals(this.versionByBpmnProcessId.get(d.getBpmnProcessId()).getVersion())).peek(d -> oldProcessDefinitionKeys.add(this.versionByBpmnProcessId.get(d.getBpmnProcessId()).getKey())).collect(Collectors.toSet());
        HashSet<ProcessDefinition> brandNew = new HashSet<ProcessDefinition>(notYetRegistered);
        brandNew.removeAll(upgraded);
        Set<Long> deleted = this.registeredProcessDefinitionKeys.stream().filter(k -> definitions.stream().noneMatch(d -> Objects.equals(d.getKey(), k))).filter(k -> !oldProcessDefinitionKeys.contains(k)).collect(Collectors.toSet());
        this.logResult(brandNew, upgraded, deleted);
        this.meter(brandNew.size());
        notYetRegistered.forEach(definition -> this.versionByBpmnProcessId.put(definition.getBpmnProcessId(), (ProcessDefinition)definition));
        HashSet<Long> toDeregister = new HashSet<Long>(oldProcessDefinitionKeys);
        toDeregister.addAll(deleted);
        if (!toDeregister.isEmpty()) {
            this.connectorManager.handleDeletedProcessDefinitions(toDeregister);
        }
        if (!notYetRegistered.isEmpty()) {
            this.connectorManager.handleNewProcessDefinitions(notYetRegistered);
        }
        this.registeredProcessDefinitionKeys.addAll(notYetRegistered.stream().map(ProcessDefinition::getKey).toList());
        this.registeredProcessDefinitionKeys.removeAll(deleted);
        this.registeredProcessDefinitionKeys.removeAll(oldProcessDefinitionKeys);
    }

    private void logResult(Set<ProcessDefinition> brandNew, Set<ProcessDefinition> upgraded, Set<Long> deleted) {
        if (brandNew.isEmpty() && upgraded.isEmpty() && deleted.isEmpty()) {
            LOG.debug("No changes in process definitions");
            return;
        }
        LOG.info("Detected changes in process definitions");
        LOG.info(". {} newly deployed", (Object)brandNew.size());
        for (ProcessDefinition pd : brandNew) {
            LOG.info(". Process: {}, version: {} for tenant: {}", new Object[]{pd.getBpmnProcessId(), pd.getVersion(), pd.getTenantId()});
        }
        LOG.info(". {} replaced with new version", (Object)upgraded.size());
        for (ProcessDefinition pd : upgraded) {
            Long oldVersion = this.versionByBpmnProcessId.get(pd.getBpmnProcessId()).getVersion();
            LOG.info(". Process: {}, version {} - replaced with version {} for tenant: {}", new Object[]{pd.getBpmnProcessId(), oldVersion, pd.getVersion(), pd.getTenantId()});
        }
        LOG.info(". {} deleted", (Object)deleted.size());
        for (Long key : deleted) {
            LOG.info(". . Key {}", (Object)key);
        }
    }

    private void meter(int count) {
        if (this.metricsRecorder != null) {
            this.metricsRecorder.increase("camunda.connector.inbound.process-definitions-checked", null, null, count);
        }
    }

    public boolean isReady() {
        return this.ready;
    }
}

