/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound.lifecycle;

import io.camunda.connector.api.annotation.InboundConnector;
import io.camunda.connector.api.inbound.InboundConnectorExecutable;
import io.camunda.connector.runtime.core.config.ConnectorConfiguration;
import io.camunda.connector.runtime.core.config.InboundConnectorConfiguration;
import io.camunda.connector.runtime.core.inbound.InboundConnectorFactory;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.spring.client.annotation.processor.AbstractZeebeAnnotationProcessor;
import io.camunda.zeebe.spring.client.bean.BeanInfo;
import io.camunda.zeebe.spring.client.bean.ClassInfo;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;

public class InboundConnectorAnnotationProcessor
extends AbstractZeebeAnnotationProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final InboundConnectorFactory inboundConnectorFactory;
    private final ConfigurableBeanFactory configurableBeanFactory;

    public InboundConnectorAnnotationProcessor(InboundConnectorFactory inboundConnectorFactory, ConfigurableBeanFactory configurableBeanFactory) {
        this.inboundConnectorFactory = inboundConnectorFactory;
        this.configurableBeanFactory = configurableBeanFactory;
    }

    public boolean isApplicableFor(ClassInfo beanInfo) {
        return beanInfo.hasClassAnnotation(InboundConnector.class);
    }

    public void configureFor(ClassInfo beanInfo) {
        beanInfo.getAnnotation(InboundConnector.class).map(inboundConnector -> this.registerInboundConnector((InboundConnector)inboundConnector, (BeanInfo)beanInfo));
    }

    private InboundConnectorConfiguration registerInboundConnector(InboundConnector inboundConnector, BeanInfo beanInfo) {
        String scope = this.configurableBeanFactory.getMergedBeanDefinition(beanInfo.getBeanName()).getScope();
        if (!"prototype".equals(scope)) {
            throw new IllegalStateException("Only \"prototype\" scope is supported for inbound connectors but found: \"" + scope + "\" for bean: " + String.valueOf(beanInfo.getBean()));
        }
        InboundConnectorConfiguration configuration = new InboundConnectorConfiguration(inboundConnector.name(), inboundConnector.type(), beanInfo.getTargetClass(), () -> (InboundConnectorExecutable)this.configurableBeanFactory.getBean(beanInfo.getTargetClass()));
        LOGGER.info("Configuring inbound connector {} of bean '{}'", (Object)configuration, (Object)beanInfo.getBeanName());
        this.inboundConnectorFactory.registerConfiguration((ConnectorConfiguration)configuration);
        return configuration;
    }

    public void start(ZeebeClient client) {
    }

    public void stop(ZeebeClient client) {
    }
}

