/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound.lifecycle;

import com.google.common.collect.EvictingQueue;
import io.camunda.connector.api.inbound.Health;
import io.camunda.connector.api.inbound.InboundConnectorContext;
import io.camunda.connector.api.inbound.InboundConnectorDefinition;
import io.camunda.connector.api.inbound.InboundConnectorExecutable;
import io.camunda.connector.api.inbound.webhook.WebhookConnectorExecutable;
import io.camunda.connector.runtime.core.inbound.InboundConnectorContextFactory;
import io.camunda.connector.runtime.core.inbound.InboundConnectorContextImpl;
import io.camunda.connector.runtime.core.inbound.InboundConnectorDefinitionImpl;
import io.camunda.connector.runtime.core.inbound.InboundConnectorFactory;
import io.camunda.connector.runtime.inbound.importer.ProcessDefinitionInspector;
import io.camunda.connector.runtime.inbound.lifecycle.ActiveInboundConnector;
import io.camunda.connector.runtime.inbound.lifecycle.ActiveInboundConnectorQuery;
import io.camunda.connector.runtime.inbound.webhook.WebhookConnectorRegistry;
import io.camunda.operate.model.ProcessDefinition;
import io.camunda.zeebe.spring.client.metrics.MetricsRecorder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class InboundConnectorManager {
    private static final Logger LOG = LoggerFactory.getLogger(InboundConnectorManager.class);
    private final InboundConnectorFactory connectorFactory;
    private final InboundConnectorContextFactory connectorContextFactory;
    private final ProcessDefinitionInspector processDefinitionInspector;
    private final WebhookConnectorRegistry webhookConnectorRegistry;
    private final MetricsRecorder metricsRecorder;
    private final Map<Long, Set<ActiveInboundConnector>> activeConnectorsByProcDefKey = new HashMap<Long, Set<ActiveInboundConnector>>();
    private final Set<Long> registeredProcessDefinitions = new HashSet<Long>();
    @Value(value="${camunda.connector.inbound.log.size:10}")
    private int inboundLogsSize;
    private final BiPredicate<ActiveInboundConnector, String> tenantIdMatch = (connector, tenantId) -> {
        InboundConnectorDefinition definition = connector.context().getDefinition();
        return tenantId != null && tenantId.equals(definition.tenantId());
    };

    public InboundConnectorManager(InboundConnectorFactory connectorFactory, InboundConnectorContextFactory connectorContextFactory, ProcessDefinitionInspector processDefinitionInspector, MetricsRecorder metricsRecorder, @Autowired(required=false) WebhookConnectorRegistry webhookConnectorRegistry) {
        this.connectorFactory = connectorFactory;
        this.connectorContextFactory = connectorContextFactory;
        this.processDefinitionInspector = processDefinitionInspector;
        this.metricsRecorder = metricsRecorder;
        this.webhookConnectorRegistry = webhookConnectorRegistry;
    }

    public void handleNewProcessDefinitions(Set<ProcessDefinition> newProcessDefinitions) {
        List connectorsToActivate = newProcessDefinitions.stream().peek(d -> this.registeredProcessDefinitions.add(d.getKey())).flatMap(d -> {
            try {
                return this.processDefinitionInspector.findInboundConnectors((ProcessDefinition)d).stream();
            }
            catch (Exception e) {
                LOG.error("Failed to inspect process definition {}", (Object)d.getKey(), (Object)e);
                throw new RuntimeException(e);
            }
        }).toList();
        for (InboundConnectorDefinitionImpl connector : connectorsToActivate) {
            try {
                this.activateConnector(connector);
            }
            catch (Exception e) {
                LOG.error("Failed to activate connector {}", (Object)connector, (Object)e);
            }
        }
    }

    public void handleDeletedProcessDefinitions(Set<Long> deletedProcessDefinitionKeys) {
        List connectorsToDeactivate = deletedProcessDefinitionKeys.stream().flatMap(key -> this.activeConnectorsByProcDefKey.getOrDefault(key, Collections.emptySet()).stream()).toList();
        for (ActiveInboundConnector connector : connectorsToDeactivate) {
            try {
                this.deactivateConnector(connector);
            }
            catch (Exception e) {
                LOG.error("Failed to deactivate connector {}", (Object)connector, (Object)e);
            }
        }
    }

    public boolean isProcessDefinitionRegistered(Long key) {
        return this.registeredProcessDefinitions.contains(key);
    }

    private void activateConnector(InboundConnectorDefinitionImpl newConnector) {
        InboundConnectorExecutable executable = (InboundConnectorExecutable)this.connectorFactory.getInstance(newConnector.type());
        Consumer<Throwable> cancellationCallback = throwable -> this.deactivateConnector(newConnector);
        InboundConnectorContext inboundContext = this.connectorContextFactory.createContext(newConnector, cancellationCallback, executable.getClass(), EvictingQueue.create((int)this.inboundLogsSize));
        ActiveInboundConnector connector = new ActiveInboundConnector(executable, inboundContext);
        try {
            InboundConnectorContextImpl inboundContextImpl;
            this.addActiveConnector(connector);
            if (this.webhookConnectorRegistry == null && executable instanceof WebhookConnectorExecutable) {
                throw new Exception("Cannot activate webhook connector. Check whether property camunda.connector.webhook.enabled is set to true.");
            }
            executable.activate(inboundContext);
            if (this.isWebhookConnector(connector)) {
                this.webhookConnectorRegistry.register(connector);
                LOG.trace("Registering webhook: " + newConnector.type());
            }
            this.metricsRecorder.increase("camunda.connector.inbound.activations", "activated", newConnector.type());
            if (inboundContext instanceof InboundConnectorContextImpl && Health.Status.UNKNOWN.equals((Object)(inboundContextImpl = (InboundConnectorContextImpl)inboundContext).getHealth().getStatus())) {
                inboundContext.reportHealth(Health.up());
            }
        }
        catch (Exception e) {
            inboundContext.reportHealth(Health.down((Throwable)e));
            LOG.error("Failed to activate inbound connector " + String.valueOf(newConnector), (Throwable)e);
            this.metricsRecorder.increase("camunda.connector.inbound.activations", "activation-failed", newConnector.type());
        }
    }

    private void addActiveConnector(ActiveInboundConnector connector) {
        this.activeConnectorsByProcDefKey.compute(connector.context().getDefinition().processDefinitionKey(), (bpmnId, connectors) -> {
            if (connectors == null) {
                HashSet<ActiveInboundConnector> set = new HashSet<ActiveInboundConnector>();
                set.add(connector);
                return set;
            }
            connectors.add(connector);
            return connectors;
        });
    }

    private void deactivateConnector(InboundConnectorDefinitionImpl definition) {
        this.findActiveConnector(definition).ifPresent(this::deactivateConnector);
        this.metricsRecorder.increase("camunda.connector.inbound.activations", "deactivated", definition.type());
    }

    private void deactivateConnector(ActiveInboundConnector connector) {
        try {
            connector.executable().deactivate();
            this.activeConnectorsByProcDefKey.get(connector.context().getDefinition().processDefinitionKey()).remove(connector);
            if (this.isWebhookConnector(connector) && this.webhookConnectorRegistry.isRegistered(connector)) {
                this.webhookConnectorRegistry.deregister(connector);
                LOG.trace("Unregistering webhook: " + connector.context().getDefinition().type());
            }
            this.metricsRecorder.increase("camunda.connector.inbound.activations", "deactivated", connector.context().getDefinition().type());
        }
        catch (Exception e) {
            LOG.error("Failed to deactivate inbound connector " + String.valueOf(connector), (Throwable)e);
        }
    }

    private Optional<ActiveInboundConnector> findActiveConnector(InboundConnectorDefinitionImpl definition) {
        return Optional.ofNullable(this.activeConnectorsByProcDefKey.get(definition.processDefinitionKey())).flatMap(connectors -> connectors.stream().filter(c -> c.context().getDefinition().equals((Object)definition)).findFirst());
    }

    public List<ActiveInboundConnector> query(ActiveInboundConnectorQuery request) {
        List<ActiveInboundConnector> filteredByBpmnProcessId = this.filterByBpmnProcessId(request.bpmnProcessId());
        List<ActiveInboundConnector> filteredByType = this.filterByConnectorType(filteredByBpmnProcessId, request.type());
        List<ActiveInboundConnector> filteredByTenantId = this.filterByTenantId(filteredByType, request.tenantId());
        return this.filterByElementId(filteredByTenantId, request.elementId());
    }

    private List<ActiveInboundConnector> filterByTenantId(List<ActiveInboundConnector> connectors, String tenantId) {
        if (tenantId == null) {
            return connectors;
        }
        return connectors.stream().filter(r -> this.tenantIdMatch.test((ActiveInboundConnector)r, tenantId)).collect(Collectors.toList());
    }

    private List<ActiveInboundConnector> filterByBpmnProcessId(String bpmnProcessId) {
        if (bpmnProcessId != null) {
            return this.activeConnectorsByProcDefKey.values().stream().flatMap(Collection::stream).filter(connector -> bpmnProcessId.equals(connector.context().getDefinition().bpmnProcessId())).toList();
        }
        return this.activeConnectorsByProcDefKey.values().stream().flatMap(Collection::stream).toList();
    }

    private List<ActiveInboundConnector> filterByConnectorType(List<ActiveInboundConnector> connectors, String type) {
        if (type == null) {
            return connectors;
        }
        return connectors.stream().filter(props -> type.equals(props.context().getDefinition().type())).collect(Collectors.toList());
    }

    private List<ActiveInboundConnector> filterByElementId(List<ActiveInboundConnector> connectors, String elementId) {
        if (elementId == null) {
            return connectors;
        }
        return connectors.stream().filter(connector -> elementId.equals(connector.context().getDefinition().elementId())).collect(Collectors.toList());
    }

    private boolean isWebhookConnector(ActiveInboundConnector connector) {
        return this.webhookConnectorRegistry != null && connector.executable() instanceof WebhookConnectorExecutable;
    }
}

