/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound.lifecycle;

import io.camunda.connector.api.inbound.Activity;
import io.camunda.connector.api.inbound.Health;
import io.camunda.connector.api.inbound.InboundConnectorDefinition;
import io.camunda.connector.api.inbound.webhook.WebhookConnectorExecutable;
import io.camunda.connector.runtime.core.inbound.InboundConnectorReportingContext;
import io.camunda.connector.runtime.inbound.lifecycle.ActiveInboundConnector;
import io.camunda.connector.runtime.inbound.lifecycle.ActiveInboundConnectorQuery;
import io.camunda.connector.runtime.inbound.lifecycle.ActiveInboundConnectorResponse;
import io.camunda.connector.runtime.inbound.lifecycle.InboundConnectorManager;
import io.camunda.connector.runtime.inbound.webhook.model.CommonWebhookProperties;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class InboundConnectorRestController {
    private static final Logger LOG = LoggerFactory.getLogger(InboundConnectorRestController.class);
    private final InboundConnectorManager inboundManager;

    public InboundConnectorRestController(InboundConnectorManager inboundManager) {
        this.inboundManager = inboundManager;
    }

    @GetMapping(value={"/inbound"})
    public List<ActiveInboundConnectorResponse> getActiveInboundConnectors(@RequestParam(required=false, value="bpmnProcessId") String bpmnProcessId, @RequestParam(required=false, value="elementId") String elementId, @RequestParam(required=false, value="type") String type) {
        return this.getActiveInboundConnectors(bpmnProcessId, elementId, type, null);
    }

    @GetMapping(value={"/tenants/{tenantId}/inbound"})
    public List<ActiveInboundConnectorResponse> getActiveInboundConnectorsForTenantId(@PathVariable(value="tenantId") String tenantId, @RequestParam(required=false, value="bpmnProcessId") String bpmnProcessId, @RequestParam(required=false, value="elementId") String elementId, @RequestParam(required=false, value="type") String type) {
        return this.getActiveInboundConnectors(bpmnProcessId, elementId, type, tenantId);
    }

    @GetMapping(value={"/tenants/{tenantId}/inbound/{bpmnProcessId}/{elementId}/logs"})
    public List<Queue<Activity>> getActiveInboundConnectorLogs(@PathVariable(value="tenantId") String tenantId, @PathVariable(value="bpmnProcessId") String bpmnProcessId, @PathVariable(value="elementId") String elementId) {
        List<ActiveInboundConnector> result = this.inboundManager.query(new ActiveInboundConnectorQuery(bpmnProcessId, elementId, null, tenantId));
        return result.stream().map(connector -> ((InboundConnectorReportingContext)connector.context()).getLogs()).collect(Collectors.toList());
    }

    private List<ActiveInboundConnectorResponse> getActiveInboundConnectors(String bpmnProcessId, String elementId, String type, String tenantId) {
        List<ActiveInboundConnector> result = this.inboundManager.query(new ActiveInboundConnectorQuery(bpmnProcessId, elementId, type, tenantId));
        return result.stream().map(this::mapToInboundResponse).collect(Collectors.toList());
    }

    private Map<String, Object> getData(ActiveInboundConnector connector) {
        Map<String, Object> data = Map.of();
        if (connector.executable() instanceof WebhookConnectorExecutable) {
            try {
                CommonWebhookProperties castedProps = (CommonWebhookProperties)connector.context().bindProperties(CommonWebhookProperties.class);
                data = Map.of("path", castedProps.getContext());
            }
            catch (Exception e) {
                LOG.error("ERROR: webhook connector doesn't have context path property", (Throwable)e);
            }
        }
        return data;
    }

    private ActiveInboundConnectorResponse mapToInboundResponse(ActiveInboundConnector connector) {
        InboundConnectorDefinition definition = connector.context().getDefinition();
        Health health = ((InboundConnectorReportingContext)connector.context()).getHealth();
        return new ActiveInboundConnectorResponse(definition.bpmnProcessId(), definition.version(), definition.elementId(), definition.type(), definition.tenantId(), this.getData(connector), health);
    }
}

