/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.inbound.webhook;

import io.camunda.connector.runtime.inbound.lifecycle.ActiveInboundConnector;
import io.camunda.connector.runtime.inbound.webhook.WebhookConnectorValidationUtil;
import io.camunda.connector.runtime.inbound.webhook.model.CommonWebhookProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebhookConnectorRegistry {
    private final Logger LOG = LoggerFactory.getLogger(WebhookConnectorRegistry.class);
    private final Map<String, ActiveInboundConnector> activeEndpointsByContext = new HashMap<String, ActiveInboundConnector>();

    public Optional<ActiveInboundConnector> getWebhookConnectorByContextPath(String context) {
        return Optional.ofNullable(this.activeEndpointsByContext.get(context));
    }

    public boolean isRegistered(ActiveInboundConnector connector) {
        String context = ((CommonWebhookProperties)connector.context().bindProperties(CommonWebhookProperties.class)).getContext();
        return this.activeEndpointsByContext.containsKey(context) && this.activeEndpointsByContext.get(context) == connector;
    }

    public void register(ActiveInboundConnector connector) {
        CommonWebhookProperties properties = (CommonWebhookProperties)connector.context().bindProperties(CommonWebhookProperties.class);
        String context = properties.getContext();
        WebhookConnectorValidationUtil.logIfWebhookPathDeprecated(connector, context);
        ActiveInboundConnector existingEndpoint = this.activeEndpointsByContext.putIfAbsent(context, connector);
        this.checkIfEndpointExists(existingEndpoint, context);
    }

    private void checkIfEndpointExists(ActiveInboundConnector existingEndpoint, String context) {
        if (existingEndpoint != null) {
            String bpmnProcessId = existingEndpoint.context().getDefinition().bpmnProcessId();
            String elementId = existingEndpoint.context().getDefinition().elementId();
            String logMessage = "Context: " + context + " already in use by " + bpmnProcessId + "/" + elementId + ".";
            this.LOG.debug(logMessage);
            throw new RuntimeException(logMessage);
        }
    }

    public void deregister(ActiveInboundConnector connector) {
        String context = ((CommonWebhookProperties)connector.context().bindProperties(CommonWebhookProperties.class)).getContext();
        ActiveInboundConnector registeredConnector = this.activeEndpointsByContext.get(context);
        if (registeredConnector == null) {
            String logMessage = "Context: " + context + " is not registered. Cannot deregister.";
            this.LOG.debug(logMessage);
            throw new RuntimeException(logMessage);
        }
        if (registeredConnector != connector) {
            String bpmnProcessId = registeredConnector.context().getDefinition().bpmnProcessId();
            String elementId = registeredConnector.context().getDefinition().elementId();
            String logMessage = "Context: " + context + " is not registered by " + bpmnProcessId + "/" + elementId + ". Cannot deregister.";
            this.LOG.debug(logMessage);
            throw new RuntimeException(logMessage);
        }
        this.activeEndpointsByContext.remove(context);
    }

    public void reset() {
        this.activeEndpointsByContext.clear();
    }
}

