/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.metrics;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.LoggerContextListener;
import ch.qos.logback.classic.turbo.TurboFilter;
import ch.qos.logback.core.spi.FilterReply;
import io.micrometer.common.lang.NonNullApi;
import io.micrometer.common.lang.NonNullFields;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.logging.LogbackMetrics;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;

@NonNullApi
public class ContextAwareLogbackMetrics
extends LogbackMetrics {
    static ThreadLocal<Boolean> ignoreMetrics = new ThreadLocal();
    private final Iterable<Tag> tags;
    private final LoggerContext loggerContext;
    private final Map<MeterRegistry, MetricsTurboFilter> metricsTurboFilters = new HashMap<MeterRegistry, MetricsTurboFilter>();

    public ContextAwareLogbackMetrics() {
        this(Collections.emptyList());
    }

    public ContextAwareLogbackMetrics(Iterable<Tag> tags) {
        this(tags, (LoggerContext)LoggerFactory.getILoggerFactory());
    }

    public ContextAwareLogbackMetrics(Iterable<Tag> tags, LoggerContext context) {
        this.tags = tags;
        this.loggerContext = context;
        this.loggerContext.addListener(new LoggerContextListener(){

            public boolean isResetResistant() {
                return true;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onReset(LoggerContext context) {
                Map<MeterRegistry, MetricsTurboFilter> map = ContextAwareLogbackMetrics.this.metricsTurboFilters;
                synchronized (map) {
                    for (MetricsTurboFilter metricsTurboFilter : ContextAwareLogbackMetrics.this.metricsTurboFilters.values()) {
                        ContextAwareLogbackMetrics.this.loggerContext.addTurboFilter((TurboFilter)metricsTurboFilter);
                    }
                }
            }

            public void onStart(LoggerContext context) {
            }

            public void onStop(LoggerContext context) {
            }

            public void onLevelChange(Logger logger, Level level) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bindTo(MeterRegistry registry) {
        MetricsTurboFilter filter = new MetricsTurboFilter(registry, this.tags);
        Map<MeterRegistry, MetricsTurboFilter> map = this.metricsTurboFilters;
        synchronized (map) {
            this.metricsTurboFilters.put(registry, filter);
            this.loggerContext.addTurboFilter((TurboFilter)filter);
        }
    }

    public static void ignoreMetrics(Runnable runnable) {
        ignoreMetrics.set(true);
        try {
            runnable.run();
        }
        finally {
            ignoreMetrics.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map<MeterRegistry, MetricsTurboFilter> map = this.metricsTurboFilters;
        synchronized (map) {
            for (MetricsTurboFilter metricsTurboFilter : this.metricsTurboFilters.values()) {
                this.loggerContext.getTurboFilterList().remove((Object)metricsTurboFilter);
            }
        }
    }

    static {
        LoggerFactory.getILoggerFactory();
    }

    @NonNullApi
    @NonNullFields
    static class MetricsTurboFilter
    extends TurboFilter {
        private static final String METER_NAME = "logback.events";
        private static final String METER_DESCRIPTION = "Number of log events that were enabled by the effective log level";
        private final Counter.Builder errorCounterTemplate;
        private final Counter.Builder warnCounterTemplate;
        private final Counter.Builder infoCounterTemplate;
        private final Counter.Builder debugCounterTemplate;
        private final Counter.Builder traceCounterTemplate;
        private final MeterRegistry registry;
        private final Map<String, Counters> countersByLoggerName = new ConcurrentHashMap<String, Counters>();

        MetricsTurboFilter(MeterRegistry registry, Iterable<Tag> tags) {
            this.registry = registry;
            this.errorCounterTemplate = Counter.builder((String)METER_NAME).tags(tags).tags(new String[]{"level", "error"}).description(METER_DESCRIPTION).baseUnit("events");
            this.warnCounterTemplate = Counter.builder((String)METER_NAME).tags(tags).tags(new String[]{"level", "warn"}).description(METER_DESCRIPTION).baseUnit("events");
            this.infoCounterTemplate = Counter.builder((String)METER_NAME).tags(tags).tags(new String[]{"level", "info"}).description(METER_DESCRIPTION).baseUnit("events");
            this.debugCounterTemplate = Counter.builder((String)METER_NAME).tags(tags).tags(new String[]{"level", "debug"}).description(METER_DESCRIPTION).baseUnit("events");
            this.traceCounterTemplate = Counter.builder((String)METER_NAME).tags(tags).tags(new String[]{"level", "trace"}).description(METER_DESCRIPTION).baseUnit("events");
        }

        public FilterReply decide(Marker marker, Logger logger, Level level, String format, Object[] params, Throwable t) {
            if (format == null || !level.isGreaterOrEqual(logger.getEffectiveLevel())) {
                return FilterReply.NEUTRAL;
            }
            Boolean ignored = ignoreMetrics.get();
            if (ignored != null && ignored.booleanValue()) {
                return FilterReply.NEUTRAL;
            }
            ContextAwareLogbackMetrics.ignoreMetrics(() -> this.recordMetrics(level, logger));
            return FilterReply.NEUTRAL;
        }

        private void recordMetrics(Level level, Logger logger) {
            String loggerName = logger.getName();
            Counters counters = this.countersByLoggerName.computeIfAbsent(loggerName, this::createCounters);
            switch (level.toInt()) {
                case 40000: {
                    counters.errorCounter.increment();
                    break;
                }
                case 30000: {
                    counters.warnCounter.increment();
                    break;
                }
                case 20000: {
                    counters.infoCounter.increment();
                    break;
                }
                case 10000: {
                    counters.debugCounter.increment();
                    break;
                }
                case 5000: {
                    counters.traceCounter.increment();
                }
            }
        }

        private Counters createCounters(String loggerName) {
            return new Counters(this.errorCounterTemplate.tags(new String[]{"logger", loggerName}).register(this.registry), this.warnCounterTemplate.tags(new String[]{"logger", loggerName}).register(this.registry), this.infoCounterTemplate.tags(new String[]{"logger", loggerName}).register(this.registry), this.debugCounterTemplate.tags(new String[]{"logger", loggerName}).register(this.registry), this.traceCounterTemplate.tags(new String[]{"logger", loggerName}).register(this.registry));
        }

        private record Counters(Counter errorCounter, Counter warnCounter, Counter infoCounter, Counter debugCounter, Counter traceCounter) {
        }
    }
}

