/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.outbound.lifecycle;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.connector.api.outbound.OutboundConnectorFunction;
import io.camunda.connector.api.validation.ValidationProvider;
import io.camunda.connector.runtime.core.config.OutboundConnectorConfiguration;
import io.camunda.connector.runtime.core.outbound.OutboundConnectorFactory;
import io.camunda.connector.runtime.core.secret.SecretProviderAggregator;
import io.camunda.connector.runtime.outbound.jobhandling.SpringConnectorJobHandler;
import io.camunda.connector.runtime.outbound.lifecycle.OutboundConnectorConfigurationComparator;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.api.worker.JobHandler;
import io.camunda.zeebe.spring.client.annotation.value.ZeebeWorkerValue;
import io.camunda.zeebe.spring.client.jobhandling.CommandExceptionHandlingStrategy;
import io.camunda.zeebe.spring.client.jobhandling.JobWorkerManager;
import io.camunda.zeebe.spring.client.metrics.MetricsRecorder;
import java.time.Duration;
import java.util.Arrays;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutboundConnectorManager {
    private static final Logger LOG = LoggerFactory.getLogger(OutboundConnectorManager.class);
    private final JobWorkerManager jobWorkerManager;
    private final OutboundConnectorFactory connectorFactory;
    private final CommandExceptionHandlingStrategy commandExceptionHandlingStrategy;
    private final SecretProviderAggregator secretProviderAggregator;
    private final ValidationProvider validationProvider;
    private final ObjectMapper objectMapper;
    private final MetricsRecorder metricsRecorder;

    public OutboundConnectorManager(JobWorkerManager jobWorkerManager, OutboundConnectorFactory connectorFactory, CommandExceptionHandlingStrategy commandExceptionHandlingStrategy, SecretProviderAggregator secretProviderAggregator, ValidationProvider validationProvider, ObjectMapper objectMapper, MetricsRecorder metricsRecorder) {
        this.jobWorkerManager = jobWorkerManager;
        this.connectorFactory = connectorFactory;
        this.commandExceptionHandlingStrategy = commandExceptionHandlingStrategy;
        this.secretProviderAggregator = secretProviderAggregator;
        this.validationProvider = validationProvider;
        this.objectMapper = objectMapper;
        this.metricsRecorder = metricsRecorder;
    }

    public void start(ZeebeClient client) {
        TreeSet<OutboundConnectorConfiguration> outboundConnectors = new TreeSet<OutboundConnectorConfiguration>(new OutboundConnectorConfigurationComparator());
        outboundConnectors.addAll(this.connectorFactory.getConfigurations());
        outboundConnectors.forEach(connector -> this.openWorkerForOutboundConnector(client, (OutboundConnectorConfiguration)connector));
    }

    public void stop() {
        this.jobWorkerManager.closeAllOpenWorkers();
    }

    private void openWorkerForOutboundConnector(ZeebeClient client, OutboundConnectorConfiguration connector) {
        ZeebeWorkerValue zeebeWorkerValue = new ZeebeWorkerValue();
        zeebeWorkerValue.setName(connector.name());
        zeebeWorkerValue.setType(connector.type());
        zeebeWorkerValue.setFetchVariables(Arrays.asList(connector.inputVariables()));
        if (connector.timeout() != null) {
            zeebeWorkerValue.setTimeout(Duration.ofMillis(connector.timeout()));
        }
        zeebeWorkerValue.setAutoComplete(Boolean.valueOf(true));
        OutboundConnectorFunction connectorFunction = (OutboundConnectorFunction)this.connectorFactory.getInstance(connector.type());
        LOG.trace("Opening worker for connector {}", (Object)connector.name());
        SpringConnectorJobHandler connectorJobHandler = new SpringConnectorJobHandler(this.metricsRecorder, this.commandExceptionHandlingStrategy, this.secretProviderAggregator, this.validationProvider, this.objectMapper, connectorFunction, connector);
        this.jobWorkerManager.openWorker(client, zeebeWorkerValue, (JobHandler)connectorJobHandler);
    }
}

