/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.connector.runtime.util.outbound;

import io.camunda.connector.api.outbound.OutboundConnectorFunction;
import io.camunda.connector.impl.ConnectorUtil;
import io.camunda.connector.impl.outbound.OutboundConnectorConfiguration;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OutboundConnectorRegistrationHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(OutboundConnectorRegistrationHelper.class);
    public static final Pattern CONNECTOR_FUNCTION_PATTERN = Pattern.compile("^CONNECTOR_(.*)_FUNCTION$");
    public static Map<String, String> hardwiredEnvironmentVariables;

    public static void addHardwiredEnvironmentVariable(String key, String value) {
        if (hardwiredEnvironmentVariables == null) {
            hardwiredEnvironmentVariables = new HashMap<String, String>();
        }
        hardwiredEnvironmentVariables.put(key, value);
    }

    public static void clearHardwiredEnvironmentVariable() {
        hardwiredEnvironmentVariables = null;
    }

    public static Map<String, String> getEnvironmentVariables() {
        if (hardwiredEnvironmentVariables != null) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.putAll(System.getenv());
            result.putAll(hardwiredEnvironmentVariables);
            return result;
        }
        return System.getenv();
    }

    public static boolean isEnvConfigured() {
        return OutboundConnectorRegistrationHelper.getEnvironmentVariables().entrySet().stream().anyMatch(entry -> CONNECTOR_FUNCTION_PATTERN.matcher((CharSequence)entry.getKey()).matches());
    }

    public static List<OutboundConnectorConfiguration> parse() {
        if (OutboundConnectorRegistrationHelper.isEnvConfigured()) {
            LOGGER.info("Reading environment variables to find connectors that are not Spring beans");
            return OutboundConnectorRegistrationHelper.parseFromEnv();
        }
        LOGGER.info("Parsing SPI to find connectors that are not Spring beans");
        return OutboundConnectorRegistrationHelper.parseFromSPI();
    }

    public static List<OutboundConnectorConfiguration> parseFromSPI() {
        return ServiceLoader.load(OutboundConnectorFunction.class).stream().map(functionProvider -> {
            OutboundConnectorFunction function = (OutboundConnectorFunction)functionProvider.get();
            return ConnectorUtil.getOutboundConnectorConfiguration(function.getClass()).map(cfg -> new OutboundConnectorConfiguration(cfg.getName(), cfg.getType(), cfg.getInputVariables(), function)).orElseThrow(() -> new RuntimeException(String.format("OutboundConnectorFunction %s is missing @OutboundConnector annotation", function.getClass())));
        }).collect(Collectors.toUnmodifiableList());
    }

    public static List<OutboundConnectorConfiguration> parseFromEnv() {
        ArrayList<OutboundConnectorConfiguration> connectors = new ArrayList<OutboundConnectorConfiguration>();
        for (Map.Entry<String, String> entry : OutboundConnectorRegistrationHelper.getEnvironmentVariables().entrySet()) {
            String key = entry.getKey();
            Matcher match = CONNECTOR_FUNCTION_PATTERN.matcher(key);
            if (!match.matches()) continue;
            connectors.add(OutboundConnectorRegistrationHelper.parseConnector(match.group(1)));
        }
        return connectors;
    }

    private static OutboundConnectorConfiguration parseConnector(String name) {
        OutboundConnectorFunction function = OutboundConnectorRegistrationHelper.getEnv(name, "FUNCTION").map(OutboundConnectorRegistrationHelper::loadConnectorFunction).orElseThrow(() -> OutboundConnectorRegistrationHelper.envMissing("No function specified", name, "FUNCTION"));
        Optional config = ConnectorUtil.getOutboundConnectorConfiguration(function.getClass());
        if (config.isEmpty()) {
            LOGGER.warn("OutboundConnectorFunction {} is missing @OutboundConnector annotation", (Object)function.getClass().getName());
        }
        return new OutboundConnectorConfiguration(name, OutboundConnectorRegistrationHelper.getEnv(name, "TYPE").or(() -> config.map(OutboundConnectorConfiguration::getType)).orElseThrow(() -> OutboundConnectorRegistrationHelper.envMissing("Type not specified", name, "TYPE")), OutboundConnectorRegistrationHelper.getEnv(name, "INPUT_VARIABLES").map(variables -> variables.split(",")).or(() -> config.map(OutboundConnectorConfiguration::getInputVariables)).orElseThrow(() -> OutboundConnectorRegistrationHelper.envMissing("Variables not specified", name, "INPUT_VARIABLES")), function);
    }

    private static Optional<String> getEnv(String name, String detail) {
        return Optional.ofNullable(OutboundConnectorRegistrationHelper.getEnvironmentVariables().get("CONNECTOR_" + name + "_" + detail));
    }

    private static OutboundConnectorFunction loadConnectorFunction(String clsName) {
        try {
            Class<?> cls = Class.forName(clsName);
            return (OutboundConnectorFunction)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw OutboundConnectorRegistrationHelper.loadFailed("Failed to load " + clsName, e);
        }
    }

    private static RuntimeException loadFailed(String s, Exception e) {
        return new IllegalStateException(s, e);
    }

    private static RuntimeException envMissing(String message, String name, String envKey) {
        return new RuntimeException(String.format("%s: Please configure it via CONNECTOR_%s_%s environment variable", message, name, envKey));
    }
}

