/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */

package io.camunda.identity.sdk.users.dto;

import com.fasterxml.jackson.annotation.JsonProperty;

public class User {
  private final String id;
  private final String username;
  private final String name;
  private final String email;

  public User(
      @JsonProperty("id") final String id,
      @JsonProperty("username") final String username,
      @JsonProperty("name") final String name,
      @JsonProperty("email") final String email
  ) {
    this.id = id;
    this.username = username;
    this.name = name;
    this.email = email;
  }

  public String getId() {
    return id;
  }

  public String getUsername() {
    return username;
  }

  public String getName() {
    return name;
  }

  public String getEmail() {
    return email;
  }
}
