/*
 * Copyright Camunda Services GmbH and/or licensed to Camunda Services GmbH under
 * one or more contributor license agreements. Licensed under a proprietary license. See the
 * License.txt file for more information. You may not use this file except in compliance with the
 * proprietary license.
 */
package io.camunda.identity.sdk.authentication;

import java.net.URI;

public abstract class AuthorizeUriBuilder {
  protected String state = "";

  /**
   * Sets the OAuth2 state parameter.
   *
   * @param state the state
   * @return the authorize url builder
   */
  public AuthorizeUriBuilder withState(final String state) {
    this.state = state;
    return this;
  }

  /**
   * Builds and returns the authorize uri.
   * Will throw a {@link IllegalArgumentException} when called more than once on a single builder
   * instance.
   *
   * @return the uri
   */
  public abstract URI build();
}
