/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.configuration;

import io.camunda.common.auth.Authentication;
import io.camunda.common.auth.DefaultNoopAuthentication;
import io.camunda.common.auth.Product;
import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.ZeebeClientConfiguration;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.impl.oauth.OAuthCredentialsProviderBuilder;
import io.camunda.zeebe.client.impl.util.Environment;
import io.camunda.zeebe.spring.client.jobhandling.ZeebeClientExecutorService;
import io.camunda.zeebe.spring.client.properties.CommonConfigurationProperties;
import io.camunda.zeebe.spring.client.properties.ZeebeClientConfigurationProperties;
import io.grpc.ClientInterceptor;
import io.grpc.Status;
import jakarta.annotation.PostConstruct;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.util.StringUtils;

public class ZeebeClientConfigurationSpringImpl
implements ZeebeClientConfiguration {
    @Autowired
    private ZeebeClientConfigurationProperties properties;
    @Autowired
    private CommonConfigurationProperties commonConfigurationProperties;
    @Autowired
    private Authentication authentication;
    @Lazy
    @Autowired
    private JsonMapper jsonMapper;
    @Lazy
    @Autowired(required=false)
    private List<ClientInterceptor> interceptors;
    @Lazy
    @Autowired
    private ZeebeClientExecutorService zeebeClientExecutorService;
    private CredentialsProvider credentialsProvider;

    @PostConstruct
    public void applyLegacy() {
        this.properties.applyOverrides();
    }

    public String getGatewayAddress() {
        return this.properties.getGatewayAddress();
    }

    public URI getRestAddress() {
        return this.properties.getRestAddress();
    }

    public URI getGrpcAddress() {
        return this.properties.getGrpcAddress();
    }

    public String getDefaultTenantId() {
        return this.properties.getDefaultTenantId();
    }

    public List<String> getDefaultJobWorkerTenantIds() {
        return this.properties.getDefaultJobWorkerTenantIds();
    }

    public int getNumJobWorkerExecutionThreads() {
        return this.properties.getNumJobWorkerExecutionThreads();
    }

    public int getDefaultJobWorkerMaxJobsActive() {
        return this.properties.getDefaultJobWorkerMaxJobsActive();
    }

    public String getDefaultJobWorkerName() {
        return this.properties.getDefaultJobWorkerName();
    }

    public Duration getDefaultJobTimeout() {
        return this.properties.getDefaultJobTimeout();
    }

    public Duration getDefaultJobPollInterval() {
        return this.properties.getDefaultJobPollInterval();
    }

    public Duration getDefaultMessageTimeToLive() {
        return this.properties.getDefaultMessageTimeToLive();
    }

    public Duration getDefaultRequestTimeout() {
        return this.properties.getDefaultRequestTimeout();
    }

    public boolean isPlaintextConnectionEnabled() {
        return this.properties.isPlaintextConnectionEnabled();
    }

    public String getCaCertificatePath() {
        return this.properties.getCaCertificatePath();
    }

    public CredentialsProvider getCredentialsProvider() {
        if (this.credentialsProvider == null) {
            this.credentialsProvider = this.initCredentialsProvider();
        }
        return this.credentialsProvider;
    }

    public Duration getKeepAlive() {
        return this.properties.getKeepAlive();
    }

    public List<ClientInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public JsonMapper getJsonMapper() {
        return this.jsonMapper;
    }

    public String getOverrideAuthority() {
        return this.properties.getOverrideAuthority();
    }

    public int getMaxMessageSize() {
        return this.properties.getMaxMessageSize();
    }

    public ScheduledExecutorService jobWorkerExecutor() {
        return this.zeebeClientExecutorService.get();
    }

    public boolean ownsJobWorkerExecutor() {
        return this.properties.ownsJobWorkerExecutor();
    }

    public boolean getDefaultJobWorkerStreamEnabled() {
        return this.properties.getDefaultJobWorkerStreamEnabled();
    }

    public boolean useDefaultRetryPolicy() {
        return this.properties.useDefaultRetryPolicy();
    }

    public boolean preferRestOverGrpc() {
        return false;
    }

    private CredentialsProvider initCredentialsProvider() {
        if (this.commonConfigurationProperties.getEnabled().booleanValue() && !(this.authentication instanceof DefaultNoopAuthentication)) {
            return new CredentialsProvider(){

                public void applyCredentials(CredentialsProvider.CredentialsApplier applier) {
                    Map.Entry<String, String> authHeader = ZeebeClientConfigurationSpringImpl.this.authentication.getTokenHeader(Product.ZEEBE);
                    applier.put(authHeader.getKey(), authHeader.getValue());
                }

                public boolean shouldRetryRequest(CredentialsProvider.StatusCode statusCode) {
                    return statusCode.code() == Status.Code.DEADLINE_EXCEEDED.value();
                }
            };
        }
        if (StringUtils.hasText((String)this.properties.getCloud().getClientId()) && StringUtils.hasText((String)this.properties.getCloud().getClientSecret())) {
            return CredentialsProvider.newCredentialsProviderBuilder().clientId(this.properties.getCloud().getClientId()).clientSecret(this.properties.getCloud().getClientSecret()).audience(this.properties.getCloud().getAudience()).scope(this.properties.getCloud().getScope()).authorizationServerUrl(this.properties.getCloud().getAuthUrl()).credentialsCachePath(this.properties.getCloud().getCredentialsCachePath()).build();
        }
        if (Environment.system().get("ZEEBE_CLIENT_ID") != null && Environment.system().get("ZEEBE_CLIENT_SECRET") != null) {
            OAuthCredentialsProviderBuilder builder = CredentialsProvider.newCredentialsProviderBuilder();
            int separatorIndex = this.properties.getBroker().getGatewayAddress().lastIndexOf(58);
            if (separatorIndex > 0) {
                builder.audience(this.properties.getBroker().getGatewayAddress().substring(0, separatorIndex));
            }
            return builder.build();
        }
        return null;
    }

    public String toString() {
        return "ZeebeClientConfiguration{properties=" + String.valueOf(this.properties) + ", commonConfigurationProperties=" + String.valueOf(this.commonConfigurationProperties) + ", authentication=" + String.valueOf(this.authentication) + ", jsonMapper=" + String.valueOf(this.jsonMapper) + ", interceptors=" + String.valueOf(this.interceptors) + "}";
    }
}

