/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.annotation.processor;

import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.spring.client.annotation.processor.AbstractZeebeAnnotationProcessor;
import io.camunda.zeebe.spring.client.bean.ClassInfo;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

public class ZeebeAnnotationProcessorRegistry
implements BeanPostProcessor,
Ordered {
    private final List<AbstractZeebeAnnotationProcessor> processors;

    public ZeebeAnnotationProcessorRegistry(List<AbstractZeebeAnnotationProcessor> processors) {
        this.processors = processors;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        ClassInfo beanInfo = ClassInfo.builder().bean(bean).beanName(beanName).build();
        for (AbstractZeebeAnnotationProcessor zeebePostProcessor : this.processors) {
            if (!zeebePostProcessor.isApplicableFor(beanInfo)) continue;
            zeebePostProcessor.configureFor(beanInfo);
        }
        return bean;
    }

    public void startAll(ZeebeClient client) {
        this.processors.forEach(zeebePostProcessor -> zeebePostProcessor.start(client));
    }

    public void stopAll(ZeebeClient client) {
        this.processors.forEach(zeebePostProcessor -> zeebePostProcessor.stop(client));
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

