/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.common.auth;

import io.camunda.common.auth.Authentication;
import io.camunda.common.auth.JwtAuthentication;
import io.camunda.common.auth.JwtConfig;
import io.camunda.common.auth.Product;
import io.camunda.common.auth.SelfManagedAuthenticationBuilder;
import io.camunda.common.auth.identity.IdentityConfig;
import io.camunda.identity.sdk.Identity;
import io.camunda.identity.sdk.authentication.Tokens;
import java.lang.invoke.MethodHandles;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelfManagedAuthentication
extends JwtAuthentication {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private JwtConfig jwtConfig;
    private IdentityConfig identityConfig;
    private Map<Product, String> tokens = new HashMap<Product, String>();

    public static SelfManagedAuthenticationBuilder builder() {
        return new SelfManagedAuthenticationBuilder();
    }

    public JwtConfig getJwtConfig() {
        return this.jwtConfig;
    }

    public void setJwtConfig(JwtConfig jwtConfig) {
        this.jwtConfig = jwtConfig;
    }

    public void setIdentityConfig(IdentityConfig identityConfig) {
        this.identityConfig = identityConfig;
    }

    @Override
    public Authentication build() {
        return this;
    }

    @Override
    public void resetToken(Product product) {
        this.tokens.remove((Object)product);
    }

    @Override
    public Map.Entry<String, String> getTokenHeader(Product product) {
        String token;
        if (this.tokens.containsKey((Object)product)) {
            token = this.tokens.get((Object)product);
        } else {
            token = this.getIdentityToken(product);
            this.saveToken(product, token);
        }
        return new AbstractMap.SimpleEntry<String, String>("Authorization", "Bearer " + token);
    }

    private String getIdentityToken(Product product) {
        Identity identity = this.identityConfig.get(product).getIdentity();
        String audience = this.jwtConfig.getProduct(product).getAudience();
        Tokens identityTokens = identity.authentication().requestToken(audience);
        return identityTokens.getAccessToken();
    }

    private void saveToken(Product product, String token) {
        this.tokens.put(product, token);
    }
}

