/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.common.auth;

import io.camunda.common.auth.Authentication;
import io.camunda.common.auth.Product;
import io.camunda.common.auth.SimpleAuthenticationBuilder;
import io.camunda.common.auth.SimpleConfig;
import io.camunda.common.auth.SimpleCredential;
import java.lang.invoke.MethodHandles;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.UrlEncodedFormEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleAuthentication
implements Authentication {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SimpleConfig simpleConfig;
    private final Map<Product, String> tokens = new HashMap<Product, String>();

    public SimpleAuthentication(SimpleConfig simpleConfig) {
        this.simpleConfig = simpleConfig;
    }

    public SimpleConfig getSimpleConfig() {
        return this.simpleConfig;
    }

    public static SimpleAuthenticationBuilder builder() {
        return new SimpleAuthenticationBuilder();
    }

    private String retrieveToken(Product product, SimpleCredential simpleCredential) {
        try (CloseableHttpClient client = HttpClients.createDefault();){
            HttpPost request = this.buildRequest(simpleCredential);
            String cookie = (String)client.execute((ClassicHttpRequest)request, response -> {
                Header[] cookieHeaders = response.getHeaders("Set-Cookie");
                String cookieCandidate = null;
                String cookiePrefix = product.toString().toUpperCase() + "-SESSION";
                for (Header cookieHeader : cookieHeaders) {
                    if (!cookieHeader.getValue().startsWith(cookiePrefix)) continue;
                    cookieCandidate = cookieHeader.getValue();
                    break;
                }
                return cookieCandidate;
            });
            if (cookie == null) {
                throw new RuntimeException("Unable to authenticate due to missing Set-Cookie");
            }
            this.tokens.put(product, cookie);
        }
        catch (Exception e) {
            LOG.error("Authenticating for " + String.valueOf((Object)product) + " failed due to " + String.valueOf(e));
            throw new RuntimeException("Unable to authenticate", e);
        }
        return this.tokens.get((Object)product);
    }

    private HttpPost buildRequest(SimpleCredential simpleCredential) {
        HttpPost httpPost = new HttpPost(simpleCredential.getBaseUrl() + "/api/login");
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("username", simpleCredential.getUser()));
        params.add(new BasicNameValuePair("password", simpleCredential.getPassword()));
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params));
        return httpPost;
    }

    @Override
    public Map.Entry<String, String> getTokenHeader(Product product) {
        String token;
        if (this.tokens.containsKey((Object)product)) {
            token = this.tokens.get((Object)product);
        } else {
            SimpleCredential simpleCredential = this.simpleConfig.getProduct(product);
            token = this.retrieveToken(product, simpleCredential);
        }
        return new AbstractMap.SimpleEntry<String, String>("Cookie", token);
    }

    @Override
    public void resetToken(Product product) {
        this.tokens.remove((Object)product);
    }
}

